/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.collaboration;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.syntax.IDiagramElementSyntaxModelBinder;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.PoolEditorModel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;

public class PoolSyntaxModelBinder implements IDiagramElementSyntaxModelBinder{

	public void bindSyntaxModel(IModelElement diagramElementSyntaxModel,
			IEditorModel editorModel, IDiagramElement diagramElement) {
		
		
	    ParticipantBean participantBean 	= (ParticipantBean) diagramElementSyntaxModel;
		PoolEditorModel poolEditorModel 	= (PoolEditorModel) editorModel;
		
		
		participantBean.setName(poolEditorModel.getName());
		participantBean.setDocumentation(poolEditorModel.getDocumentation());
		participantBean.setInterfaces(poolEditorModel.getInterfaces());
		
		if (poolEditorModel.getParticipantMultiplicityMax()!=null) participantBean.setMaximumMultiplicity(Integer.parseInt(poolEditorModel.getParticipantMultiplicityMax()));
		if (poolEditorModel.getParticipantMultiplicityMin()!=null) participantBean.setMinimumMultiplicity(Integer.parseInt(poolEditorModel.getParticipantMultiplicityMin()));
		

	
	
	}

}
