/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.collaboration;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.common.CoreContainer;

public abstract class Swimlane extends CoreContainer{

	public Swimlane(ProcessPanel definitionPanel, String id) {
		super(definitionPanel, id);
		
	}

	
	public HashSet<IDiagramElementViewConformityRule> getConformityRules() {
		HashSet<IDiagramElementViewConformityRule> rules = new HashSet<IDiagramElementViewConformityRule>();
		
		DescriptiveProcessSwimlaneRules descrules = new DescriptiveProcessSwimlaneRules(this); 
		rules.addAll(descrules.getRules());
		
		
		if (getDefinitionPanel().isExecutableProcess()){
			ExecutableProcessSwimlaneRules execRules = new ExecutableProcessSwimlaneRules(this);
			rules.addAll(execRules.getRules());
		}
		
		return rules;
	}

	
}
