/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.collaboration;


import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxyData;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.collaboration.CollapsedPool;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.common.AbstractBPMNDragProxy;


public class CollapsedPoolDragProxy extends AbstractBPMNDragProxy {
	
	
	public CollapsedPoolDragProxy(IUIPanel uipanel) {
		super(uipanel);
		
	}

	public IHasDragProxyData getData() {
		
		return null;
	}


	@Override
	protected String getDescription() {
		return "A Collapsed Pool represents an external participant";
	}

	@Override
	protected String getBigIcon() {
		return "images/ico/bpmn/collaboration/collapsed-pool.png";
	}

	@Override
	protected String getLabel() {
		return "Collapsed Pool";
	}


	public Class<? extends IUIElement> getIUIElementType() {
		return CollapsedPool.class;
	}

	@Override
	protected String getSmallIcon() {
		return "images/ico/bpmn/collaboration/collapsed-pool16x16.png";
	}

	

}
