/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.events;

import java.util.HashSet;
import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasMenuDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DraggableProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.connectors.SequenceFlow;

public abstract class EndEvent extends Event {

	public EndEvent(ProcessPanel definitionPanel, String id) {
		super(definitionPanel, id);

		 this.addDropHandler(this);
		
	}

	public LinkedHashSet<IHasMenuDragProxy> getDragProxies() {

		return null;
	}

	public HashSet<Class<? extends IDraggableElement>> getAcceptedTypes() {
		HashSet<Class<? extends IDraggableElement>> result = new HashSet<Class<? extends IDraggableElement>>();
		 
		result.add(SequenceFlow.class);
		 
		return result;
	}

	
	public void onDropAccepted(IDropAcceptedEvent event) {
		//if a sequence flow is dropped from a HasMenuDragProxy connect  
		if (event.getDraggableElement() instanceof DraggableProxy){
			
			DraggableProxy dp = (DraggableProxy) event.getDraggableElement();
			
			if (dp.getHasDraggableElementProxy() instanceof IHasMenuDragProxy){
				
				IHasMenuDragProxy hmdp = (IHasMenuDragProxy) (dp.getHasDraggableElementProxy());
				
				if (dp.getHasDraggableElementProxy().getIUIElementType()==SequenceFlow.class){
					
					SequenceFlow sf = (SequenceFlow) getUIPanel().getElementFactory().getElement(SequenceFlow.class);
					getUIPanel().addUIElement(sf);
					
					sf.connect((IConnectableElement) hmdp.getContextualMenuSubject(), this);
					
				}
				
			}
			
			
		}
	}
}
