/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.modeleditor.template;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.AbstractUITemplate;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.common.IBPMNElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.ActivityEditorModel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public abstract class AbstractTemplate extends AbstractUITemplate {
	
	private IBPMNElement bpmnElement;
	
	// hook to register subclasses
	private List<Class<? extends IEditorModel>> subclasses;
	
	public AbstractTemplate(IBPMNElement bpmnElement) {
		
		this.bpmnElement = bpmnElement;
		this.bpmnElement.setFormTemplate(this);
		this.initMappingPolicies() ;
		
	}
	
	public AbstractTemplate() {
	
	}

	
	@Override
	public void refresh() {
		

		
	}
	
	public AbstractTemplate(IDiagramView bpmnDiagram) {
	
	}

	@Override
	public Widget getTemplate() {
		
		VerticalPanel vp						 		= new VerticalPanel();
		
		Label lbl = new Label();
		
		lbl.getElement().setAttribute("style", "font-weight:bold;font-size:14px;");
		lbl.setText(getTitle());
		vp.add(lbl);
		
		ArrayList<LabelWidgetPair> allLabelWidgetPair 	= new ArrayList<LabelWidgetPair>();

		
		
		allLabelWidgetPair.addAll(getPairs());

		
		Grid grid = new Grid(allLabelWidgetPair.size(),2);
		
		for(int i=0;i<=allLabelWidgetPair.size()-1;i++){
			
			LabelWidgetPair lwp = allLabelWidgetPair.get(i);
			
				grid.setWidget(i, 0, new Label(lwp.getLabel()));
				grid.setWidget(i, 1, lwp.getWidget());
			
		}
		
		vp.add(grid);
		
		return vp;
	}
	
	
	abstract protected List<LabelWidgetPair> getPairs();
	
	protected String getTitle(){
		return bpmnElement.getName();
	}
	
	
	protected class LabelWidgetPair{
		
		private String label;
		private Widget widget;
		
		public LabelWidgetPair(String label,Widget widget) {
			this.label = label;
			this.widget = widget;
		}
		
		public String getLabel() {
			return label;
		}
		
		public Widget getWidget() {
			return widget;
		}
	}
	
	protected void initMappingPolicies(){
	    if (this.subclasses == null){
            this.subclasses = new ArrayList<Class<? extends IEditorModel>>();
        }
        
        registerSubclasses();
	}
	
	public IBPMNElement getBpmnElement() {
		return bpmnElement;
	}
	
	
	/**
     * Registers a class as a subclass of AbstractTemplate 
     * This method must be used only when overriding in registerSubclasses()
     * @param <T>
     * @param clazz
     */
    protected <T extends ActivityEditorModel> void registerSubclass(Class<T> clazz){
        subclasses.add(clazz);
    }
    
    /**
     * Method called during initialization cycle
     * It should contain calls to registerSubclass() only.
     * The default implementation does nothing at all.
     * 
     * @see AbstractTemplate#registerSubclass(Class)
     * @see AbstractTemplate#initMappingPolicies()
     * 
     */
    protected void registerSubclasses(){
        
    }

    /**
     * Use this method in subclasses when adding custom fields in subclasses
     * @return
     */
    /*
     * NOTE : This method is safe, as only subclasses are able to call this method and register themselves. 
     */
    protected List<Class<? extends IEditorModel>> getSubclasses() {
        return subclasses;
    }
}
