/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.modeleditor.template;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.EnclosedFieldMappingPolicy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.IInstantiationHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.UIBindingManager;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.ListUIField;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.DisplayEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.IUIFieldHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.common.CoreBPMNElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.MessageEventEditorModel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.IMessageEventDefinitionBean;
import com.google.gwt.user.client.ui.Widget;

public class MessageEventFormTemplate extends CommonFormTemplate {
	
	public MessageEventFormTemplate(CoreBPMNElement bpmnElement) {
		super(bpmnElement);
	}

	@Override
	protected List<LabelWidgetPair> getPairs() {
		ArrayList<LabelWidgetPair> result = new ArrayList<LabelWidgetPair>();	
		
		result.addAll(super.getPairs());
		
		ProcessPanel processPanel = (ProcessPanel) getBpmnElement().getUIPanel();
		
		Widget taskType = (Widget) this.getUIField("messageEventDefinition"); 
		
		if (taskType!=null && processPanel.isExecutableProcess()) result.add(new LabelWidgetPair("Definition", taskType));
		
		return result;
	}

	
	@Override
	protected void initMappingPolicies() {
		super.initMappingPolicies();
		
		final IDefinitionsBean defs  = (IDefinitionsBean) getBpmnElement().getMainModel();

		EnclosedFieldMappingPolicy emfp1 = new EnclosedFieldMappingPolicy(MessageEventEditorModel.class, "messageEventDefinition",new IInstantiationHandler<ListUIField<IMessageEventDefinitionBean>>() {
		
			@Override
			public ListUIField<IMessageEventDefinitionBean> instantiate() {
				final ListUIField<IMessageEventDefinitionBean> msgDefList = new ListUIField<IMessageEventDefinitionBean>(defs.getMessageEventDefinitions());
				
				msgDefList.addUIFieldHandler(new IUIFieldHandler() {
					
					@Override
					public void onDisplay(DisplayEvent event) {
						
						msgDefList.setOptions(defs.getMessageEventDefinitions());
						
					}
				});
				return msgDefList;
			}
		
		});
		
		UIBindingManager.getInstance().addClassMappingPolicy(emfp1);
		
		
	}
	
	

	

}
