/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.process.activities;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleLevel;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.AbstractDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleLevel;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectable;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.connectors.SequenceFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.connectors.SequenceFlowType;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.ActivityEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.SequenceFlowEditorModel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.gateway.ISequenceFlowBean;

public class DescriptiveProcessActivityRules {
	
	private Activity activity;
	
	private HashSet<IDiagramElementViewConformityRule> rules;
	
	public DescriptiveProcessActivityRules(Activity activity) {
		
		this.activity = activity;
		
		this.rules = new HashSet<IDiagramElementViewConformityRule>();
		
		this.rules.add(new ActivityMustHaveAtLeast1IncommingSeqFlowOr1OutgoingSeqFlow(activity));
		this.rules.add(new ActivityHavingAnOutgoingSequenceFlowWithAConditionMustHaveADefaulSequenceFlow(activity));
	}
	
	public HashSet<IDiagramElementViewConformityRule> getRules() {
		return rules;
	}
	
	/////////////////////
	//BPMN SPECIFICATION RULES: ERRORS
	///////////////////////
	
	
	////////////////ACTIVITY MUST HAVE AT LEAST 1 INCOMMING OR 1 OUTGOINT SEQUENCEFLOW
	private class ActivityMustHaveAtLeast1IncommingSeqFlowOr1OutgoingSeqFlow extends AbstractDiagramElementViewConformityRule {

		public ActivityMustHaveAtLeast1IncommingSeqFlowOr1OutgoingSeqFlow(IDiagramElementView diagramElementView) {
			super(diagramElementView);
			
		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			
			
			IConnectable connectable = (IConnectable) diagramElementView;
			
			if (connectable.getIncommingConnectors().size()==0 && connectable.getOutgoingConnectors().size()==0){
				return false;
			}
			
			return true;
		}

		@Override
		public boolean canResolveNonConformity() {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "Connect actual activity to another flow node through a Sequence Flow";
		}

		@Override
		public String getRuleDescription() {
			return "Actual Activity doesn't have any incomming or outgoing Sequence Flow";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "No incomming or outgoing Sequence Flow";
		}

		@Override
		public void resolveNonConformity() {
		
		}
		
		
		
		
	}
	
	
	////////////////////AN ACTIVITY HAVING AN OUTGOING SEQUENCE FLOW WITH A CONDITION MUST HAVE A DEFAULT SEQUENCE FLOW
	private class ActivityHavingAnOutgoingSequenceFlowWithAConditionMustHaveADefaulSequenceFlow extends AbstractDiagramElementViewConformityRule {

		public ActivityHavingAnOutgoingSequenceFlowWithAConditionMustHaveADefaulSequenceFlow(
				IDiagramElementView diagramElementView) {
			super(diagramElementView);

		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			
			IConnectable connectable = (IConnectable) diagramElementView;
			
			ISequenceFlowBean conditionalSequenceFlow = null;
			//search for outgoing connectors with 
			for(IConnector c:connectable.getOutgoingConnectors()){
				
				if  (c instanceof SequenceFlow){
					
					SequenceFlow seqFlow = (SequenceFlow) c;
					
					if (seqFlow.getType()==SequenceFlowType.CONDITIONAL){
						
						conditionalSequenceFlow  = (ISequenceFlowBean) seqFlow.getDiagramElement().getModelElement();
						
						break;
					}
					
				}
				
			}
			
			if (conditionalSequenceFlow!=null){
				
				
				ActivityEditorModel model = (ActivityEditorModel) diagramElementView.getEditorModel();
				
				if (model.getDefaultSequenceFlow()!=null && model.getDefaultSequenceFlow()!=conditionalSequenceFlow){
					return true;
				}
				
				
				return false;
				
			}else{
				return true;
			}
			
			

		}

		@Override
		public boolean canResolveNonConformity() {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "Add a default sequence flow";
		}

		@Override
		public String getRuleDescription() {
			return "An activity with a conditional outgoing sequence flow must have a default outgoing sequence flow";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "No default outgoing sequence flow detected";
		}

		@Override
		public void resolveNonConformity() {
			// TODO Auto-generated method stub
			
		}
		
		
		
		
		
	}
	
	
}
