/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.activities;

import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxyData;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.common.AbstractBPMNDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.SendTask;

public class SendTaskDragProxy extends AbstractBPMNDragProxy{
	
	
	public SendTaskDragProxy(IUIPanel uipanel) {
		super(uipanel);
		

		
		
	}

	public IHasDragProxyData getData() {
		
		return null;
	}


	@Override
	protected String getDescription() {
		return "A Send Task is a simple Task that is designed to send a Message to an external Participant (relative to the Process). Once the Message has been sent, the Task is completed.";
	}

	@Override
	protected String getBigIcon() {
		return "images/ico/bpmn/activity/task_send.png";
	}

	@Override
	protected String getLabel() {
		return "Send task";
	}



	public Class<? extends IUIElement> getIUIElementType() {
		return SendTask.class;
	}

	@Override
	protected String getSmallIcon() {
		return "images/ico/bpmn/activity/task_send16x16.png";	
	}



	

}
