/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.gateways;


import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxyData;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.common.AbstractBPMNDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways.EventBasedGateway;

public class EventBasedGatewayDragProxy extends AbstractBPMNDragProxy{

	public EventBasedGatewayDragProxy(IUIPanel uipanel) {
		super(uipanel);
	
	}

	@Override
	protected String getDescription() {
		return "An event based gateway represents an alternative branching point where the decision is based on two or more Events that might occur";
	}

	@Override
	protected String getBigIcon() {
		return "images/ico/bpmn/gateways/event-based-gateway.png";
	}

	@Override
	protected String getLabel() {
		return "Event based Gateway";
	}

	public IHasDragProxyData getData() {
		
		return null;
	}

	public Class<? extends IUIElement> getIUIElementType() {
		return EventBasedGateway.class;
	}

	@Override
	protected String getSmallIcon() {
		return "images/ico/bpmn/gateways/event-based-gateway16x16.png";
	}

}
