/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.connector.binder;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.Binder;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.connector.DataAssociationEditorModel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IAssignmentBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IExpressionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data.AssignmentBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data.DataAssociationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data.ExpressionBean;


@Binder(bindedModel = DataAssociationBean.class, watchedModel = DataAssociationEditorModel.class,watchedModelIgnoredFields={"to","from","name","itemDef"})
public abstract class DataAssociationBinder implements IBinder<DataAssociationEditorModel, DataAssociationBean>{

	@Override
	public void bind(DataAssociationEditorModel watchedModel,
			DataAssociationBean modelToBind) {
		// 1 - binding of 'to' and 'from' fields of the editor model
		//add an assignment with the 'to' and 'from' expressions
		modelToBind.getAssignements().clear();
		
		IAssignmentBean a = new AssignmentBean();
		modelToBind.addAssignement(a);
		
		IExpressionBean from = new ExpressionBean();
		from.setContent(watchedModel.getFrom());
		a.setFrom(from);
		
		IExpressionBean to = new ExpressionBean();
		to.setContent(watchedModel.getTo());
		a.setTo(to);
		
		// 2 - binding of 'itemDef' property of the editor model
		//set targetItem and sourceItem to the editor model value
		// the builder will use one of them depending if the data association 
		// is a datainputassociation or a dataoutputassociation
		modelToBind.setTargetItem(watchedModel.getItemDef());
		modelToBind.setSourceItem(watchedModel.getItemDef());
	}
	
	@Override
	public void initializeWatchedModel(DataAssociationEditorModel watchedModel,
			DataAssociationBean modelToBind) {
		// 1 - load assignments
		if(modelToBind.getAssignements()!=null && !modelToBind.getAssignements().isEmpty()) {
			IAssignmentBean a = modelToBind.getAssignements().get(0);
			if(a.getFrom()!=null) {
				watchedModel.setFrom(a.getFrom().getContent());
			}
			if(a.getTo()!=null) {
				watchedModel.setTo(a.getTo().getContent());
			}
		}
		
		// 2 - load source or target item
		if(modelToBind.getSourceItem()!=null) {
			watchedModel.setItemDef(modelToBind.getSourceItem());
		}
		else if (modelToBind.getTargetItem()!=null) {
			watchedModel.setItemDef(modelToBind.getTargetItem());
		}
	}
	
}
