/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.data.binder;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.lookup.IHasLookupProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.Binder;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.data.MessageEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.Message;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.MessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.MessageVisibleKind;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.ParticipantBandKind;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNEdge;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNShape;


@Binder(bindedModel = MessageBean.class, watchedModel = MessageEditorModel.class,watchedModelIgnoredFields="initiating")
public abstract class MessageBinder implements IBinder<MessageEditorModel, MessageBean>{

	
	@Override
	public void initializeWatchedModel(MessageEditorModel watchedModel,
			MessageBean modelToBind) {
		
		IHasLookupProxy lookupProxy = (IHasLookupProxy) watchedModel;
		
		Message message = (Message) lookupProxy.lookup(Message.class);	
		
		if (message!=null){
			
			BPMNShape shape = (BPMNShape) message.getDiagramElement();
			
			BPMNEdge associationEdge = (BPMNEdge) shape.getIncomingEdges().iterator().next();
			
			if (associationEdge!=null){
				
				BPMNShape source = (BPMNShape) associationEdge.getSource();
				
				if (source.getParticipantBandKind().isInitiating()){
					watchedModel.setInitiating(true);
				}else{
					watchedModel.setInitiating(false);
				}
				
			}
			
		}
		
	}
	
	
}
