/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.event.binder;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.Binder;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.event.IntermediateThrowingMessageEditorModel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.IMessageEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.IntermediateThrowEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.definition.MessageEventDefinitionBean;

@Binder(bindedModel = IntermediateThrowEventBean.class, watchedModel = IntermediateThrowingMessageEditorModel.class,watchedModelIgnoredFields="messageEventDefinition")
public abstract class IntermediateThrowingMessageBinder implements IBinder<IntermediateThrowingMessageEditorModel, IntermediateThrowEventBean>{


	@Override
	public void onInstantiation(IntermediateThrowingMessageEditorModel watchedModel,
			IntermediateThrowEventBean modelToBind) {
		MessageEventDefinitionBean ted = new MessageEventDefinitionBean();
		modelToBind.addResult(ted);
	}

	@Override
	public void initializeWatchedModel(IntermediateThrowingMessageEditorModel watchedModel,
			IntermediateThrowEventBean modelToBind) {
		if(modelToBind.getResults()!=null && !modelToBind.getResults().isEmpty()) {
			watchedModel.setMessageEventDefinition((IMessageEventDefinitionBean) modelToBind.getResults().get(0));
		}
	}

	@Override
	public void bind(IntermediateThrowingMessageEditorModel watchedModel,
			IntermediateThrowEventBean modelToBind) {
		if(watchedModel.getMessageEventDefinition()!=null) {
			modelToBind.getResults().clear();
			modelToBind.addResult(watchedModel.getMessageEventDefinition());
		}
	}

}
