/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.event.binder;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.Binder;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.event.StartTimerEditorModel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.ITimerEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.definition.TimerEventDefinitionBean;

@Binder(bindedModel = StartEventBean.class, watchedModel = StartTimerEditorModel.class,watchedModelIgnoredFields="timerEventDefinition")
public abstract class StartTimerBinder implements IBinder<StartTimerEditorModel, StartEventBean>{

	
	@Override
	public void onInstantiation(StartTimerEditorModel watchedModel,
			StartEventBean modelToBind) {
		TimerEventDefinitionBean ted = new TimerEventDefinitionBean();
		modelToBind.addTrigger(ted);
	}
	
	@Override
	public void initializeWatchedModel(StartTimerEditorModel watchedModel,
			StartEventBean modelToBind) {
		if(modelToBind.getTriggers()!=null && !modelToBind.getTriggers().isEmpty()) {
			watchedModel.setTimerEventDefinition((ITimerEventDefinitionBean) modelToBind.getTriggers().get(0));
		}
	}

	@Override
	public void bind(StartTimerEditorModel watchedModel, StartEventBean modelToBind) {
	    if(watchedModel.getTimerEventDefinition()!=null) {
            modelToBind.getTriggers().clear();
            modelToBind.addTrigger(watchedModel.getTimerEventDefinition());
        }
	}
}
