/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.swimlane;


import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.lookup.IHasLookupProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.IMethodCalledEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.IObservableHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.ISetterCalledEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.Field;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.choreography.ChoreographyTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.choreography.Participant;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.choreography.ChoreographyTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;

/**
 * Used to set the initiating participant on ChoreographyTask only
 * @author nfleury
 *
 */
public class PoolObservableHandler implements IObservableHandler{

	@Override
	public void onMethodCalled(IMethodCalledEvent event) {

		
	}

	@Override
	public void onSetterCalled(final ISetterCalledEvent event) {
		
		//FIXME: SHOULD NOT USE SHEDULEDCOMMAND HERE
		//Temporary solution to deal with the fact that when this method is called
		//participant's container is not yet the ChoreographyTask but still the ChoreographyDiagram
		Scheduler.get().scheduleDeferred(new ScheduledCommand() {
			
			@Override
			public void execute() {

					Field field = event.getField();
					
					if (field.getName().equals("initiating")){
						
						PoolEditorModel editorModel = (PoolEditorModel) field.getEnclosingObject();
						
						//if initiating == true => set ChoreographyTask initiating participant
						if (((Boolean)field.getValue())){
							
							IHasLookupProxy lookupProxy = (IHasLookupProxy) editorModel;
							
							Participant participant = (Participant) lookupProxy.lookup(Participant.class);
							
							if (participant!=null){
								
								IContainer container 	= (IContainer) participant.getContainer();
			
								if (container!=null && (container instanceof ChoreographyTask)){
									
									ChoreographyTask ct 	= (ChoreographyTask) participant.getContainer();						
									ParticipantBean pb 			= (ParticipantBean) participant.getDiagramElement().getModelElement();
									ChoreographyTaskBean ctb 	= (ChoreographyTaskBean) ct.getDiagramElement().getModelElement();
									
									ctb.setInitiatingParticipant(pb);
									
								}
								
							}
							
						}
						
					}
			}
		});
		
		
	}

}
