/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.template;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.lookup.IHasLookupProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.template.DefaultTemplateHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.DataAssociation;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;

public class DataAssociationTemplateHandler implements DefaultTemplateHandler {

	private DataAssociationTemplate taskTemplate;
	
	public DataAssociationTemplateHandler(DataAssociationTemplate taskTemplate) {
		this.taskTemplate = taskTemplate;
	}
	
	public DataAssociationTemplate getDataAssociationTemplate() {
		return taskTemplate;
	}
	
	@Override
	public boolean load(String fieldName) {
		if (fieldName.equals("from")|| fieldName.equals("to") || fieldName.equals("itemDef")) {
			IEditorModel editorModel = (IEditorModel) this.getDataAssociationTemplate().getEditorModel();
			IHasLookupProxy lookupProxy = (IHasLookupProxy) editorModel;
			DataAssociation da = (DataAssociation) lookupProxy.lookup(DataAssociation.class);
			return ((ProcessPanel)da.getContainer()).isExecutableProcess();
		}
		return true;
	}
	
}
