/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.template;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.lookup.IHasLookupProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.template.DefaultTemplateHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.choreography.Participant;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration.CollapsedPool;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration.Pool;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;

public class PoolTemplateHandler implements DefaultTemplateHandler{
	
	private PoolTemplate poolTemplate;
	
	public PoolTemplateHandler(PoolTemplate poolTemplate) {
		this.poolTemplate = poolTemplate;
	}
	
	public PoolTemplate getTaskTemplate() {
		return poolTemplate;
	}
	
	
	@Override
	public boolean load(String fieldName) {
		
		IEditorModel editorModel = (IEditorModel) this.getTaskTemplate().getEditorModel();
		
		IHasLookupProxy lookupProxy = (IHasLookupProxy) editorModel;
		
		Pool pool = (Pool) lookupProxy.lookup(Pool.class);
		CollapsedPool collapsedPool = (CollapsedPool) lookupProxy.lookup(CollapsedPool.class);
		Participant participant = (Participant) lookupProxy.lookup(Participant.class);
		ProcessPanel panel = (ProcessPanel) lookupProxy.lookup(ProcessPanel.class);
		
		boolean isExec = false;
		
		//collapsed pool
		if (pool==null && participant==null && collapsedPool!=null && panel==null){
			isExec = collapsedPool.getDefinitionPanel().isExecutableProcess();
			if (fieldName.equals("initiating")){
				return false;
			}
		}
		//participant of a choregraphy task
		else if (pool==null && participant!=null && collapsedPool==null && panel==null) {
			isExec = false;
			if (fieldName.equals("initiating")){
				return true;
			}
			if (fieldName.equals("interfaces")|| fieldName.equals("minimumMultiplicity") || fieldName.equals("maximumMultiplicity")){
				return false;
			}
		}
		//normal pool
		else if (pool!=null && participant==null && collapsedPool==null && panel==null) {
			isExec = pool.getDefinitionPanel().isExecutableProcess();
			if (fieldName.equals("initiating")){
				return false;
			}
		}
		//default participant
		else if (pool==null && participant==null && collapsedPool==null && panel!=null) {
			isExec = panel.isExecutableProcess();
			if (fieldName.equals("initiating")){
				return false;
			}
		}
		
		if (pool!=null || collapsedPool!=null || panel!=null){
			if (isExec){
				if (fieldName.equals("interfaces")|| fieldName.equals("minimumMultiplicity") || fieldName.equals("maximumMultiplicity")){
					return true;
				}
			}else{
				if (fieldName.equals("interfaces")|| fieldName.equals("minimumMultiplicity") || fieldName.equals("maximumMultiplicity")){
					return false;
				}			
			}
		}
		return true;
	}

}
