/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.model.builder;

import java.util.Set;

import com.ebmwebsourcing.geasytools.diagrameditor.impl.syntax.SyntaxModelBuilder;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.choreography.ChoreographyTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;

public class ChoreographyTaskBuilder extends SyntaxModelBuilder<ChoreographyTaskBean>{

	@Override
	public ChoreographyTaskBean getSyntaxModel() {
		
		ChoreographyTaskBean choreoTask = (ChoreographyTaskBean) getMainDiagramElement().getModelElement();
		
		choreoTask.getParticipants().clear();
		
		//get all participants
		//ADD ALL PARTICIPANTS
		Set<ParticipantBean> participants = this.getAll(ParticipantBean.class,true);
		for(ParticipantBean p:participants){

			choreoTask.addParticipantBean(p);
			
		}
		
		
		return choreoTask;
	}

	@Override
	public Class<? extends ChoreographyTaskBean> getSyntaxModelType() {
		return ChoreographyTaskBean.class;
	}

}
