/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.model.builder;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.syntax.SyntaxModelBuilder;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.FlowElementBean;

public class LaneBuilder extends SyntaxModelBuilder<LaneBean>{

	public LaneBuilder(IDiagramElement diagramElement) {
		super(diagramElement);
		this.register(new LaneBuilder());
	}

	public LaneBuilder() {

	}
	
	@Override
	public LaneBean getSyntaxModel() {

		LaneBean lane 							= (LaneBean) this.getMainDiagramElement().getModelElement();
		
		lane.clearFlowElements();
		
		//retrieve all flow elements
		HashSet<FlowElementBean> flowElements 	= (HashSet<FlowElementBean>) this.getAll(FlowElementBean.class, false);
		
		//retrieve all lanes
		HashSet<LaneBean> childLanes 			= (HashSet<LaneBean>) this.getAll(LaneBean.class, false);
		
		//add all lanes in laneSet
		for(LaneBean l:childLanes){
			lane.getChildLaneSet().addLane(l);			
		}
		
		//add all flowElements in lane
		for(FlowElementBean flowElement : flowElements){
			lane.addFlowElement(flowElement);
		}
		
		
		return lane;
	}

	@Override
	public Class<? extends LaneBean> getSyntaxModelType() {
		return LaneBean.class;
	}

}
