/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.model.builder;

import java.util.HashMap;
import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IEdge;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.syntax.SyntaxModelBuilder;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IFlowElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;

/**
 *
 * @author nfleury
 *
 */
public class ParticipantBuilder extends SyntaxModelBuilder<ParticipantBean>{
	

	
	public ParticipantBuilder(IDiagramElement diagramElement) {
		super(diagramElement);
		this.register(new LaneBuilder());
	}

	
	public ParticipantBuilder() {
		this.register(new LaneBuilder());
	}


	@Override
	public ParticipantBean getSyntaxModel() {

		ParticipantBean participant   = (ParticipantBean) getMainDiagramElement().getModelElement();

		//clean participants process first
		participant.getProcess().getLanes().clear();
		participant.getProcess().clearFlowElements();
		participant.getProcess().clearIOSpec();
		
		//add all lanes (recursively) into participants process
		HashSet<LaneBean> lanes = (HashSet<LaneBean>) this.getAll(LaneBean.class, true);
		
		for(LaneBean lane:lanes){
			participant.getProcess().addLane(lane);
		}
		
		

		//grab all sequence flows
		HashMap<IDiagramElement,SequenceFlowBean> sequenceFlows = (HashMap<IDiagramElement, SequenceFlowBean>) this.getEdges(SequenceFlowBean.class);
		
		for(IDiagramElement di:sequenceFlows.keySet()){
			
			SequenceFlowBean s = sequenceFlows.get(di);
			s.setSourceNode((IFlowElementBean) ((IEdge)di).getSource().getModelElement());
			s.setTargetNode((IFlowElementBean) ((IEdge)di).getTarget().getModelElement());
			
			participant.getProcess().addSequenceFlow(s);
		}
		
		return participant;
	}

	@Override
	public Class<? extends ParticipantBean> getSyntaxModelType() {
		return ParticipantBean.class;
	}

}
