/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleLevel;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleLevel;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.ConnectableFlowElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.MessageFlow;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ActivityBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.CallActivityBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ReceiveTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.SendTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ServiceTaskBean;

public class ExecutableProcessActivityRules {
	
	private Activity activity;
	
	
	
	public ExecutableProcessActivityRules(Activity activity) {
		
		this.activity = activity;
		
	}
	
	public HashSet<IDiagramElementViewConformityRule> getRules(){
		
		HashSet<IDiagramElementViewConformityRule> result = new HashSet<IDiagramElementViewConformityRule>();
		
		if (activity instanceof DefaultTask){
			
			result.add(new ServiceBasedActivityMustHaveOperation());
			
		}else if (activity instanceof CallActivity){
			
			result.add(new CallActivityMustSpecifyCalledElement());
			
		}
		
	return result;
	}
	
	
	
	
	
	/////////////////////
	//BPMN SPECIFICATION RULES: ERRORS
	///////////////////////
	
	
	///////////CALL ACTIVITY///////////////
	private class CallActivityMustSpecifyCalledElement implements IDiagramElementViewConformityRule{

		private IDiagramElementView diagramElementView;
		
		@Override
		public IDiagramElementView getNonConformElement() {
			return diagramElementView;
		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			
			this.diagramElementView = diagramElementView;
			
			CallActivityBean callActivityBean = (CallActivityBean) this.diagramElementView.getDiagramElement().getModelElement();
			
			if (callActivityBean.getCalledElement()==null){
				return false;
			}
			
			return true;
		}

		@Override
		public boolean canResolveNonConformity() {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "Assign a Called Element";
		}

		@Override
		public String getRuleDescription() {
			return "Actual Call Activity does not specify any callable element";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "Called Element Required";
		}

		@Override
		public void resolveNonConformity() {
			// TODO Auto-generated method stub
			
		}
		
		
		
		
	}
	
	
	///////////SERVICE BASED TASK///////////////
	private class ServiceBasedActivityMustHaveOperation implements IDiagramElementViewConformityRule{
		
		private IDiagramElementView diagramElementView;
		
		@Override
		public IDiagramElementView getNonConformElement() {
			return diagramElementView;
		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			
			this.diagramElementView = diagramElementView;
			
			ActivityBean activityBean = (ActivityBean) diagramElementView.getDiagramElement().getModelElement();
			
			if (activityBean instanceof ServiceTaskBean){
				
				ServiceTaskBean serviceTaskBean = (ServiceTaskBean) activityBean;
				
				if (serviceTaskBean.getOperation()==null){
					return false;
				}
				
			}else if (activityBean instanceof ReceiveTaskBean){
				
				ReceiveTaskBean receiveTaskBean = (ReceiveTaskBean) activityBean;
				
				if (receiveTaskBean.getOperation()==null){
					return false;
				}
				
			}else if (activityBean instanceof SendTaskBean){
				
				SendTaskBean sendTaskBean = (SendTaskBean) activityBean;
				
				if (sendTaskBean.getOperation()==null){
					return false;
				}
				
			}
			
			return true;
		}

		@Override
		public boolean canResolveNonConformity() {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "Assign an operation to actual activity";
		}

		@Override
		public String getRuleDescription() {
			return "No Operation is assigned to actual activity";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "Operation is required";
		}

		@Override
		public void resolveNonConformity() {
			// TODO Auto-generated method stub
			
		}
		
		
		
		
	}
	
	
	
	
	private class SendTaskMustHaveAnOutgoingMessageFlow implements IDiagramElementViewConformityRule{
		
		private IDiagramElementView diagramElementView;
		
		public boolean canResolveNonConformity() {
			// TODO Auto-generated method stub
			return false;
		}

		public String getResolveConformityDescription() {
			return "Set actual task marker to 'None'";
		}

		public String getRuleDescription() {
			return "Current task is marked as a 'Send Task' but no outgoing message flow is connected";
		}

		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		public String getRuleName() {
			return "Send Task must have an outgoing message flow";
		}

		public boolean isConform(IDiagramElementView diagramElementView) {
			
			this.diagramElementView = diagramElementView;
			
			ConnectableFlowElement connectableFlow = (ConnectableFlowElement) diagramElementView;
			
			boolean isConnectedToAnOutgointMessageFlow = false;
			
			for(IConnector connector:connectableFlow.getOutgoingConnectors()){
				
				if (connector instanceof MessageFlow){
					
					return true;
					
				}
				
			}
			
			
			return isConnectedToAnOutgointMessageFlow;
		}

		public void resolveNonConformity() {
			
			
		}

		public IDiagramElementView getNonConformElement() {
			return diagramElementView;
		}
		
	}
	
	
	
	
}
