/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.artifacts;

import java.util.HashSet;
import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicState;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Rectangle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Text;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElementDefaulHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasDragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasMenuDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.events.IDragProxyContextualMenuHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.ConnectableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.contextualmenu.DragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedBeforeDropEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.artifact.TextAnnotationEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.ConnectableFlowElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.ContextualMenuHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.connector.ConnectionMode;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;
import com.google.gwt.core.client.GWT;

public class TextAnnotation extends ConnectableFlowElement implements IHasDragProxyContextualMenu{

	private Rectangle invisibleRectangle;
	
	public static final int  DEFAULT_HEIGHT = 15;
	public static final int  DEFAULT_WIDTH  = 150;

	private Text text;
	
	private ConnectableElementDefaultHandlers defaultHandlers;
	
	public TextAnnotation(ProcessPanel definitionPanel, String id) {
		super(definitionPanel, id,ConnectionMode.ALL);
		
		this.label  = this.getDefinitionPanel().getCanvas().createText(10, 25, "");
		this.label.setVisible(false);
		
		this.text    = this.getDefinitionPanel().getCanvas().createText(25, 25, "");
	

		getGroup().appendChild(text);
		
		//Add contextual menu ability
		DragProxyContextualMenu dpm = new DragProxyContextualMenu(this);
		
		this.defaultHandlers	= new ConnectableElementDefaultHandlers(this);
		this.defaultHandlers.attachDefaultHandlers();
		
		this.addContextualMenuHandler(new ContextualMenuHandler(this));
		
		Rectangle topLine 		= this.getDefinitionPanel().getCanvas().createRectangle(0, 0, 30, 1);
		Rectangle leftLine 		= this.getDefinitionPanel().getCanvas().createRectangle(0, 0, 1, 50);
		Rectangle bottomLine 	= this.getDefinitionPanel().getCanvas().createRectangle(0, 50, 30, 1);
		
		topLine.setStokeColour("#858585");
		leftLine.setStokeColour("#858585");
		bottomLine.setStokeColour("#858585");

		
		getGroup().appendChild(topLine);
		getGroup().appendChild(leftLine);
		getGroup().appendChild(bottomLine);
	}


	public void setText(String text){
		this.text.setText(text);
		this.text.setX((this.text.getWidth()/2) + 5);
	}
	
	@Override
	public HashSet<IDiagramElementGraphicState> getStates() {
		HashSet<IDiagramElementGraphicState> result = new HashSet<IDiagramElementGraphicState>();
		
		result.addAll(super.getStates());
		
		ArtifactsStates aStates = new ArtifactsStates();
		
		result.add(aStates.new TextAnnotationTextState());
		
		return result;
	}
	
	@Override
	public SVGElement getMainShape() {
		if (invisibleRectangle==null){
			invisibleRectangle = this.getDefinitionPanel().getCanvas().createRectangle(0, 0, 30, 50);
			invisibleRectangle.setStokeColour("white");
			invisibleRectangle.setFillColour("white");
		}
		return invisibleRectangle;
	}

	
	@Override
	public void refresh() {

	}

	@Override
	public String getName() {
		return "Text Annotation";
	}

	@Override
	public HashSet<IDiagramElementViewConformityRule> getConformityRules() {
		return new DescriptiveProcessArtifactRules().getRules(this);
	}

	@Override
	public IEditorModel getEditorModel() {
		if (editorModel==null){
			this.editorModel = GWT.create(TextAnnotationEditorModel.class);
		}
		return editorModel;
	}

	@Override
	public void onDropAccepted(IDropAcceptedEvent event) {
		// TODO Auto-generated method stub
	}

	@Override
	public void onDropRefused(IDropRefusedEvent event) {
		// TODO Auto-generated method stub
	}

	@Override
	public void onOut(IOutEvent event) {
		// TODO Auto-generated method stub
	}

	@Override
	public void onOver(IOverEvent event) {
		// TODO Auto-generated method stub
	}

	@Override
	public HashSet<Class<? extends IDraggableElement>> getAcceptedTypes() {
		HashSet<Class<? extends IDraggableElement>> result = new HashSet<Class<? extends IDraggableElement>>();
		return result;
	}
	
	
	public enum ParticipantLevel{
		TOP,MIDDLE,BOTTOM
	}


	@Override
	public void addContextualMenuHandler(IDragProxyContextualMenuHandler handler) {
		handlerManager.addHandler(ProxyDragStartEvent.TYPE, handler);
		handlerManager.addHandler(ProxyDragMoveEvent.TYPE, handler);
		handlerManager.addHandler(ProxyDragStopEvent.TYPE, handler);
		handlerManager.addHandler(ProxyAcceptedBeforeDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyRefusedBeforeDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyAcceptedAfterDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyRefusedAfterDropEvent.TYPE, handler);	
	}

	@Override
	public LinkedHashSet<IHasMenuDragProxy> getDragProxies() {
		LinkedHashSet<IHasMenuDragProxy> dps = new LinkedHashSet<IHasMenuDragProxy>();
		return dps;
	}

	@Override
	public Direction getMenuDirection() {
		return Direction.E;
	}

	@Override
	public IConnectableElementDefaulHandlers getDefaultHandlers() {
		return defaultHandlers;
	}
	
	

}
