/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.choreography;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IHasDefaultChildren;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Rectangle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElementDefaulHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasDragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasMenuDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.events.IDragProxyContextualMenuHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainerDefaultHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElementFactory;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IAddUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IContainerHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IRemoveUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.ConnectableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.contextualmenu.DragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.ContainerDefaultHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.events.AddUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.events.RemoveUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DraggableProxy;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedBeforeDropEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.artifact.TextAnnotationMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.choreography.ChoreographyTaskMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.connectors.SequenceFlowMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.EndNoneMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.IntermediateCatchingMessageMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.IntermediateThrowingMessageMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.gateways.ExclusiveGatewayMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.ConnectableFlowElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.ContextualMenuHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.CoreBPMNElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.connector.ConnectionMode;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.SequenceFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ChoreographyPanel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNShape;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.ParticipantBandKind;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNShape;
import com.google.gwt.core.client.GWT;

public  abstract class ChoreographyActivity extends ConnectableFlowElement implements IHasDragProxyContextualMenu,IContainer,IContainerHandler,IHasDefaultChildren{
	
	private Rectangle rectangle;
	private ConnectableElementDefaultHandlers defaultHandlers;
	private LinkedHashMap<String, IUIElement> uiElements;
	private ContainerDefaultHandler defaultHandler;
	
	private float lastYDropPosition  = -100;
	
	private LinkedHashSet<Participant> topLevelParticipants;
	private LinkedHashSet<Participant> bottomLevelParticipants;
	
	
	public ChoreographyActivity(ChoreographyPanel panel, String id) {
		super(panel, id, ConnectionMode.ALL);
		
		this.topLevelParticipants 		= new LinkedHashSet<Participant>();
		this.bottomLevelParticipants 	= new LinkedHashSet<Participant>();
		
		this.uiElements 	= new LinkedHashMap<String, IUIElement>();
		
		//Add contextual menu ability
		DragProxyContextualMenu dpm = new DragProxyContextualMenu(this);
		
		this.label  = this.getDefinitionPanel().getCanvas().createText(this.getWidth()/2, this.getHeight()/2, "");
		this.getGroup().appendChild(label);
		
		this.defaultHandlers	= new ConnectableElementDefaultHandlers(this);
		this.defaultHandlers.attachDefaultHandlers();
		
		this.addContextualMenuHandler(new ContextualMenuHandler(this));
		
		this.addDropHandler(this);
		
		this.defaultHandler = new ContainerDefaultHandler(this, panel);
		this.defaultHandler.attachDefaultHandlers();
		
		this.addContainerHandler(this);
	}

	
	public void addTopLevelParticipant(Participant participant){
		this.topLevelParticipants.add(participant);
	}
	
	public void addBottomLevelParticipant(Participant participant){
		this.bottomLevelParticipants.add(participant);
	}
	
	@Override
	public SVGElement getMainShape() {
		
		if (rectangle==null){
			rectangle = this.getDefinitionPanel().getCanvas().createRectangle(0, 0, 150, 100,5);
			rectangle.setFillColour("white");
			rectangle.setStokeColour("#000000");
		}
		
		return rectangle;
	}

	@Override
	public String getName() {
		return "Choreography Task";
	}

	@Override
	public IConnectableElementDefaulHandlers getDefaultHandlers() {
		return defaultHandlers;
	}

	public HashSet<Class<? extends IDraggableElement>> getAcceptedTypes() {
		 HashSet<Class<? extends IDraggableElement>> result = new HashSet<Class<? extends IDraggableElement>>();
		 
		 
		 result.add(Participant.class);
		 result.add(SequenceFlow.class);
		 
		 
		 return result;
	}
	
	@Override
	public LinkedHashSet<IHasMenuDragProxy> getDragProxies() {
		
		LinkedHashSet<IHasMenuDragProxy> dps = new LinkedHashSet<IHasMenuDragProxy>();
		
		//CHOREOGRAPHY
		ChoreographyTaskMenuDragProxy ctdp = new ChoreographyTaskMenuDragProxy(this.getUIPanel());
		ctdp.setLabelVisible(false);
		ctdp.setSmallIcon(true);
		
		
		//GATEWAY
		ExclusiveGatewayMenuDragProxy g1 = new ExclusiveGatewayMenuDragProxy(getUIPanel());
		g1.setLabelVisible(false);
		g1.setSmallIcon(true);
		

		

		//INTERMEDIATE THROWING
		IntermediateThrowingMessageMenuDragProxy it1 = new IntermediateThrowingMessageMenuDragProxy(getUIPanel());
		it1.setLabelVisible(false);
		it1.setSmallIcon(true);
		
		//INTERMEDIATE CATCHING
		IntermediateCatchingMessageMenuDragProxy ic1 = new IntermediateCatchingMessageMenuDragProxy(getUIPanel());
		ic1.setLabelVisible(false);
		ic1.setSmallIcon(true);		
		

		
		//END EVENT
		EndNoneMenuDragProxy endNoneDragProxy = new EndNoneMenuDragProxy(getUIPanel());
		endNoneDragProxy.setLabelVisible(false);
		endNoneDragProxy.setSmallIcon(true);
			

			
		//CONNECTORS
		SequenceFlowMenuDragProxy sdp = new SequenceFlowMenuDragProxy(getUIPanel());
		sdp.setLabelVisible(false);
		sdp.setSmallIcon(true);
		
		//Artifacts
		TextAnnotationMenuDragProxy tamdp = new TextAnnotationMenuDragProxy(getUIPanel());
		tamdp.setLabelVisible(false);
		tamdp.setSmallIcon(true);
		
		dps.add(ctdp);
		dps.add(g1);
		dps.add(it1);
		dps.add(ic1);
		dps.add(endNoneDragProxy);
		dps.add(sdp);
		dps.add(tamdp);
		
		return dps;
	}
	
	
	@Override
	public void addContextualMenuHandler(IDragProxyContextualMenuHandler handler) {
		handlerManager.addHandler(ProxyDragStartEvent.TYPE, handler);
		handlerManager.addHandler(ProxyDragMoveEvent.TYPE, handler);
		handlerManager.addHandler(ProxyDragStopEvent.TYPE, handler);
		handlerManager.addHandler(ProxyAcceptedBeforeDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyRefusedBeforeDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyAcceptedAfterDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyRefusedAfterDropEvent.TYPE, handler);	
	}
	
	@Override
	public Direction getMenuDirection() {
		return null;
	}
	
	@Override
	public HashSet<IDiagramElementViewConformityRule> getConformityRules() {
		
		HashSet<IDiagramElementViewConformityRule> result  = new HashSet<IDiagramElementViewConformityRule>();
		
		ChoreographyActivityRules car = new ChoreographyActivityRules(this);
		
		result.addAll(car.getRules());
		
		return result;
	}



	@Override
	public void onDropAccepted(IDropAcceptedEvent event) {
		
		this.lastYDropPosition = event.getY();

		//if a sequence flow is dropped from a HasMenuDragProxy connect  
		if (event.getDraggableElement() instanceof DraggableProxy){
			
			DraggableProxy dp = (DraggableProxy) event.getDraggableElement();
			
			if (dp.getHasDraggableElementProxy() instanceof IHasMenuDragProxy){
				
				IHasMenuDragProxy hmdp = (IHasMenuDragProxy) (dp.getHasDraggableElementProxy());
				
				if (dp.getHasDraggableElementProxy().getIUIElementType()==SequenceFlow.class){
					
					SequenceFlow sf = (SequenceFlow) getUIPanel().getElementFactory().getElement(SequenceFlow.class);
					getUIPanel().addUIElement(sf);
					
					sf.connect((IConnectableElement) hmdp.getContextualMenuSubject(), this);
					
				}
				
			}
			
			
		}
	}

	

	
	@Override
	public void onDropRefused(IDropRefusedEvent event) {
		// TODO Auto-generated method stub

	}

	@Override
	public void onOut(IOutEvent event) {
		// TODO Auto-generated method stub

	}

	@Override
	public void onOver(IOverEvent event) {
		// TODO Auto-generated method stub

	}

	@Override
	public void addContainerHandler(IContainerHandler handler) {
		handlerManager.addHandler(AddUIElementEvent.TYPE, handler);
		handlerManager.addHandler(RemoveUIElementEvent.TYPE, handler);
	}

	@Override
	public void addUIElement(IUIElement uiElement) {
		
		if (uiElement instanceof Participant){
			
			Participant participant = (Participant) uiElement;
			
			BPMNShape shape = (BPMNShape) participant.getDiagramElement();

			//means we are loading => not dropped by user
			if (shape.getParticipantBandKind()!=null && topLevelParticipants.contains(participant)==false && bottomLevelParticipants.contains(participant)==false ){
			
				//add to bottom or top list given element position
				if (shape.getY()<getMiddle() ){

					topLevelParticipants.add(participant);

				}else {

					bottomLevelParticipants.add(participant);

				}
			
			//else we are in user interaction mode	
			}else{
				
				if (getLastDropPosition()==Position.TOP){
					
					bottomLevelParticipants.remove(participant);
					topLevelParticipants.add(participant);	
					
				}else{
					
					topLevelParticipants.remove(participant);					
					bottomLevelParticipants.add(participant);					
					
				}
				
			}
			
		}
		
		if (uiElement instanceof CoreBPMNElement){
			
			CoreBPMNElement el = (CoreBPMNElement) uiElement;
			
			uiElement.setContainer(this);
			this.uiElements.put(uiElement.getId(), uiElement);
			this.getGroup().appendChild(el.getGroup());
			el.getGroup().setContainer(this.getGroup());
			this.fireEvent(new AddUIElementEvent(uiElement));
			uiElement.refresh();			
		}
		
		
	}
	



	
	@Override
	public void refresh() {
		super.refresh();
		//organize top level participants
		float tlYPosition = 0;

		for(Participant p:topLevelParticipants){
			p.setRelativeY(tlYPosition);
			p.setRelativeX(0);
			tlYPosition = tlYPosition + p.getHeight();
		}
		
		//organize bottom level participants
		float blYPosition = this.getHeight() - Participant.DEFAULT_HEIGHT;
		
		for(Participant p:bottomLevelParticipants) {
			p.setRelativeY(blYPosition);
			p.setRelativeX(0);
			blYPosition = blYPosition - p.getHeight();
		}
		
	}
	
	private Position getLastDropPosition(){
		
		int middle = getMiddle();

		if (lastYDropPosition>middle){
			return Position.BOTTOM;
		}else{
			return Position.TOP;
		}
		
	}
	
	private int getMiddle(){
		return (int) (this.getHeight() / 2) - (Participant.DEFAULT_HEIGHT/2);
	}
	
	@Override
	public LinkedHashMap<String, IUIElement> getChildrenUIElements() {
		return uiElements;
	}

	@Override
	public int getClientHeight() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int getClientWidth() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public IContainerDefaultHandler getContainerDefaultHandler() {
		return defaultHandler;
	}

	@Override
	public IUIElementFactory getElementFactory() {
		return this.getUIPanel().getElementFactory();
	}

	@Override
	public int getScrollLeft() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int getScrollTop() {
		// TODO Auto-generated method stub
		return 0;
	}

	public void removeAllChildren() {
		this.uiElements.clear();
	}

	public void removeChildElement(IUIElement uiElement) {
		this.uiElements.remove(uiElement.getId());
		this.fireEvent(new RemoveUIElementEvent(uiElement));
	}


	private enum Position {
		TOP,BOTTOM
	}


	@Override
	public void onAddUIElement(IAddUIElementEvent event) {

		if (event.getUIElement() instanceof Participant){
			
			Participant participant = (Participant) event.getUIElement();
			
			//ONLY IN UI MODE
			if (lastYDropPosition!=-100){//to prevent 
				
					//first determine where we should add the element (top or bottom ?) 
					if (getLastDropPosition()==Position.TOP){	
						
						BPMNShape topShape = (BPMNShape) participant.getDiagramElement();
						topShape.setChoreographyActivityShape(((BPMNShape)this.getDiagramElement()));
						
						//if its the first element in the list and there is
						//no initiating element yet in the bottom list => this is top initiating element
						if (topLevelParticipants.size()==1){
							
							boolean bottomHasInitiatingElement = false;
							
							for(Participant p:bottomLevelParticipants){
								
								BPMNShape bottomShape = (BPMNShape) p.getDiagramElement();
								
								if (bottomShape.getParticipantBandKind()==ParticipantBandKind.bottom_initiating){
									bottomHasInitiatingElement = true;
									break;
								}
								
							}
							
							
							if (bottomHasInitiatingElement == false){
								
								topShape.setParticipantBandKind(ParticipantBandKind.top_initiating);
								
							}else{
								
								topShape.setParticipantBandKind(ParticipantBandKind.top_non_initiating);
								
							}
							
						}else if (topLevelParticipants.size()>1){
							
						// if its not the first in the list => let say its a middle non initiating ....	
						//why ? i don't know !
							topShape.setParticipantBandKind(ParticipantBandKind.middle_non_initiating);
							
						}
						
					}else{
					//BOTTOM SHAPE
						
						BPMNShape bottomShape = (BPMNShape) participant.getDiagramElement();
						bottomShape.setChoreographyActivityShape(((BPMNShape)this.getDiagramElement()));
						
						//if its the first element in the list and there is
						//no initiating element yet in the bottom list => this is top initiating element
						if (bottomLevelParticipants.size()==1){
							
							boolean topHasInitiatingElement = false;
							
							for(Participant p:topLevelParticipants){
								
								BPMNShape topShape = (BPMNShape) p.getDiagramElement();
								
								if (topShape.getParticipantBandKind()==ParticipantBandKind.top_initiating){
									topHasInitiatingElement = true;
									break;
								}
								
							}
							
							
							if (topHasInitiatingElement == false){
								
								bottomShape.setParticipantBandKind(ParticipantBandKind.bottom_initiating);
								
							}else{
								
								bottomShape.setParticipantBandKind(ParticipantBandKind.bottom_non_initiating);
								
							}
							
						}else if (bottomLevelParticipants.size()>1){
							
						// if its not the first in the list => let say its a middle non initiating ....	
						//why ? i don't know !
							bottomShape.setParticipantBandKind(ParticipantBandKind.middle_non_initiating);
							
						}
						
					}
			
			}
		}
		
	}

	@Override
	public void onRemoveUIElement(IRemoveUIElementEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public Set<IDiagramElement> getChildrenDIModels() {
		
		HashSet<IDiagramElement> children = new HashSet<IDiagramElement>();
		
		BPMNShape p1Shape = GWT.create(BPMNShape.class);
		p1Shape.setParticipantBandKind(ParticipantBandKind.top_initiating);
		p1Shape.setY(1);
		p1Shape.setChoreographyActivityShape((IBPMNShape) getDiagramElement());
		
		ParticipantBean p1Bean = new ParticipantBean();
		p1Shape.setModelElement(p1Bean);

		
		BPMNShape p2Shape = GWT.create(BPMNShape.class);
		p2Shape.setParticipantBandKind(ParticipantBandKind.bottom_non_initiating);
		p2Shape.setY(getMiddle()+1);
		p2Shape.setModelElement(new ParticipantBean());
		p2Shape.setChoreographyActivityShape((IBPMNShape) getDiagramElement());

		
		children.add(p1Shape);
		children.add(p2Shape);
		
		return children;
	}
	
}
