/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.choreography;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleLevel;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.AbstractDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleLevel;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectable;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;

public class ChoreographyActivityRules {
	
	private HashSet<IDiagramElementViewConformityRule> rules;
	
	public ChoreographyActivityRules(ChoreographyActivity activity) {
		
		this.rules = new HashSet<IDiagramElementViewConformityRule>();
		
		this.rules.add(new ChoreographyActivityMustHaveAtLeast1IncommingSeqFlowOr1OutgoingSeqFlow(activity));
		this.rules.add(new ChoreographyActivityMustHaveAtLeastAndMaxOf1InitiatingParticipant(activity));
	
	}
	
	public HashSet<IDiagramElementViewConformityRule> getRules() {
		return rules;
	}
	
	/////////////////////
	//BPMN SPECIFICATION RULES: ERRORS
	///////////////////////
	
	
	////////////////ACTIVITY MUST HAVE AT LEAST 1 INCOMMING OR 1 OUTGOINT SEQUENCEFLOW
	public class ChoreographyActivityMustHaveAtLeast1IncommingSeqFlowOr1OutgoingSeqFlow extends AbstractDiagramElementViewConformityRule {

		public ChoreographyActivityMustHaveAtLeast1IncommingSeqFlowOr1OutgoingSeqFlow(IDiagramElementView diagramElementView) {
			super(diagramElementView);
			
		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			
			
			IConnectable connectable = (IConnectable) diagramElementView;
			
			if (connectable.getIncommingConnectors().size()==0 && connectable.getOutgoingConnectors().size()==0){
				return false;
			}
			
			return true;
		}

		@Override
		public boolean canResolveNonConformity() {
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "Connect current activity to another flow node through a Sequence Flow";
		}

		@Override
		public String getRuleDescription() {
			return "Current activity doesn't have any incomming or outgoing Sequence Flow";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "No incomming or outgoing Sequence Flow";
		}

		@Override
		public void resolveNonConformity() {
		
		}
		
		
		
		
	}
	
	//////////////A CHOREOGRAPHY ACTIVITY MUST HAVE AT LEAST AND A MAX OF 1 INITIATING PARTICIPANT
	public class ChoreographyActivityMustHaveAtLeastAndMaxOf1InitiatingParticipant extends AbstractDiagramElementViewConformityRule {

		public ChoreographyActivityMustHaveAtLeastAndMaxOf1InitiatingParticipant(IDiagramElementView diagramElementView) {
			super(diagramElementView);
			
		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			
			ChoreographyActivity activity = (ChoreographyActivity) diagramElementView;
			
			int nb = 0;
			
			for(IUIElement child:activity.getChildrenUIElements().values()){
				
				Participant participant = (Participant) child;
				
				if (participant.isInitiating()){
					nb++;
				}
				
			}
			
			if (nb!=1){
				return false;
			}
			
			return true;
		}

		@Override
		public boolean canResolveNonConformity() {
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "Current activity doesn't have any or too much initiating participant.";
		}

		@Override
		public String getRuleDescription() {
			return "A Choreography Activity must and can have a maximum of one initiating participant";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "Too much or no initiating participant";
		}

		@Override
		public void resolveNonConformity() {
		
		}
		
	}	

	
}
