/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.choreography;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicState;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.swimlane.PoolEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.choreography.Participant.ParticipantLevel;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.ParticipantBandKind;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNShape;

public class ChoreographyStates {

	
	public class ParticipantState implements IDiagramElementGraphicState{

		@Override
		public void changeGraphicState(IDiagramElementView diElementGraphic) {
			
			Participant participant = (Participant) diElementGraphic;
			
			//set position state
			BPMNShape shape = (BPMNShape) diElementGraphic.getDiagramElement();
			
			if (shape.getParticipantBandKind()==ParticipantBandKind.top_initiating
				|| shape.getParticipantBandKind()==ParticipantBandKind.top_non_initiating){
				
				participant.setLevel(ParticipantLevel.TOP);
			
			}else if (shape.getParticipantBandKind()==ParticipantBandKind.bottom_initiating
					|| shape.getParticipantBandKind()==ParticipantBandKind.bottom_non_initiating){
				
				participant.setLevel(ParticipantLevel.BOTTOM);
				
			}else{
				
				participant.setLevel(ParticipantLevel.MIDDLE);
				
			}
			
			//set shape participant band kind  
			PoolEditorModel poolEditorModel = (PoolEditorModel) diElementGraphic.getEditorModel();
			
//			if (poolEditorModel.isInitiating() && participant.getLevel()==ParticipantLevel.TOP){
//				shape.setParticipantBandKind(ParticipantBandKind.top_initiating);
//			}else if (poolEditorModel.isInitiating() && participant.getLevel()==ParticipantLevel.MIDDLE){
//				shape.setParticipantBandKind(ParticipantBandKind.middle_initiating);				
//			}else if (poolEditorModel.isInitiating() && participant.getLevel()==ParticipantLevel.BOTTOM){
//				shape.setParticipantBandKind(ParticipantBandKind.bottom_initiating);
//			}else if (poolEditorModel.isInitiating()==false && participant.getLevel()==ParticipantLevel.TOP){
//				shape.setParticipantBandKind(ParticipantBandKind.top_non_initiating);
//			}else if (poolEditorModel.isInitiating()==false && participant.getLevel()==ParticipantLevel.MIDDLE){
//				shape.setParticipantBandKind(ParticipantBandKind.middle_non_initiating);				
//			}else if (poolEditorModel.isInitiating()==false && participant.getLevel()==ParticipantLevel.BOTTOM){
//				shape.setParticipantBandKind(ParticipantBandKind.bottom_non_initiating);
//			}


			//set initating/non-initiating state			
			participant.setInitiating(poolEditorModel.isInitiating());
			
		}

		@Override
		public boolean condition(IDiagramElement diElement,
				IEditorModel modelElement) {

			return true;
		}
		
		
	}
	
	
	
	
	
	
}
