/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.connector;



import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Circle;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.Magnet;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Point;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;
import com.google.gwt.user.client.Timer;


public class MagnetElement extends Magnet {

	private Circle circle;
	private Timer timer;
	public MagnetElement(IConnectableElement connectable) {
		super(connectable);
		
		this.circle = ((ProcessPanel)this.getUIPanel()).getCanvas().createCircle(0, 0, 5);
		this.circle.setFillColour("white");
		this.circle.setFillOpacity(50);
		
		this.timer = new Timer() {
			
			@Override
			public void run() {
				
				hide();
				
			}
		};
		

		
		hide();
		initWidget(this.circle);
		onAttach();
	}

	
	@Override
	public void removeFromParent() {
		super.removeFromParent();
		circle.remove();
	}
	
	public IPoint getNorthWestPoint() {
		return new Point(this.getAbsoluteLeft()-10,this.getAbsoluteTop()-10);
	}

	
	public IPoint getSouthEastPoint() {
		return new Point(this.getAbsoluteLeft() + 10,this.getAbsoluteTop()+10);
	}


	
	public void setRelativeX(float x) {
		circle.setX(x);
	}

	
	public void setRelativeY(float y) {
		circle.setY(y);
	}
	
	
	public void hide(){
		circle.getElement().setAttribute("opacity", "0");
	}
	
	public void show(){
		
		circle.getElement().setAttribute("opacity", "100");
	}
	
	public void onOver(IOverEvent event) {
		super.onOver(event);
		this.timer.schedule(3000);
		if (event.getDraggableElement() instanceof ConnectorStartElement
			||event.getDraggableElement() instanceof ConnectorEndElement ){
			show();
			circle.setFillColour("red");
		}
	}
	
	@Override
	public void onOut(IOutEvent event) {
		super.onOut(event);

		if (event.getDraggableElement() instanceof ConnectorStartElement
				||event.getDraggableElement() instanceof ConnectorEndElement ){
			
			hide();
		}
	}
	
	@Override
	public void onDropAccepted(IDropAcceptedEvent event) {
		super.onDropAccepted(event);
		hide();
		circle.setFillColour("white");
	
	}
	
	@Override
	public void onDropRefused(IDropRefusedEvent event) {
		super.onDropRefused(event);
		
	}


	
}
