/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicState;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorView;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.connector.ConnectorElement;

public abstract class ConnectorFlow extends ConnectorElement {

	private IEditorView editorView;

	public ConnectorFlow(IUIPanel uipanel, String id) {
		super(uipanel, id);

	}

	public IEditorView getEditorView() {
		return editorView;
	}

	public void setEditorView(IEditorView editorView) {
		this.editorView = editorView;
	}

	public HashSet<IDiagramElementGraphicState> getStates() {
		HashSet<IDiagramElementGraphicState> states = new HashSet<IDiagramElementGraphicState>();

		ConnectorCommonStates ccs = new ConnectorCommonStates();

		states.add(ccs.new NameState());

		return states;
	}

}
