/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors;

import java.util.HashSet;
import java.util.Set;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleLevel;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.AbstractDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleLevel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.connector.DataAssociationEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.connector.ConnectorElement;

public class ExecutableProcessConnectorRules {

	private Set<IDiagramElementViewConformityRule> rules;

	public ExecutableProcessConnectorRules(ConnectorElement connector) {
		this.rules = new HashSet<IDiagramElementViewConformityRule>();
		
		if(connector instanceof DataAssociation) {
			DataAssociation da = (DataAssociation)connector;
			rules.add(new DataAssociationExpressionsMustBeSet(da));
			rules.add(new DataAssociationItemDefMustBeSet(da));
		}
		
	}

	public Set<IDiagramElementViewConformityRule> getRules() {
		return rules;
	}

	
	
	
	private class DataAssociationExpressionsMustBeSet extends AbstractDiagramElementViewConformityRule {
		
		public DataAssociationExpressionsMustBeSet(DataAssociation dataAssociation) {
			super(dataAssociation);
		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			DataAssociationEditorModel em = (DataAssociationEditorModel) diagramElementView.getEditorModel();
			return em.getFrom()!=null && !em.getFrom().isEmpty() && em.getTo()!=null && !em.getTo().isEmpty();
		}

		@Override
		public boolean canResolveNonConformity() {
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "Please set \"From\" and \"To\" properties.";
		}

		@Override
		public String getRuleDescription() {	
			return "A data association whose assigment expressions are not set will be automatically given default ones.";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.WARNING;
		}

		@Override
		public String getRuleName() {
			return "Default From and To expressions will be generated for the Data Association";
		}

		@Override
		public void resolveNonConformity() {
			
		}
	}
	
	
	private class DataAssociationItemDefMustBeSet extends AbstractDiagramElementViewConformityRule {
		
		public DataAssociationItemDefMustBeSet(DataAssociation dataAssociation) {
			super(dataAssociation);
		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			DataAssociationEditorModel em = (DataAssociationEditorModel) diagramElementView.getEditorModel();
			return em.getItemDef()!=null;
		}

		@Override
		public boolean canResolveNonConformity() {
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "Please set the \"Flow Node Item\" property.";
		}

		@Override
		public String getRuleDescription() {	
			return "The data structure used as source or target for the data association must be set.";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "Data Association \"Flow Node Item\" property is required.";
		}

		@Override
		public void resolveNonConformity() {
			
		}
	}
	
	
}
