/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagram;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.choreography.ChoreographyEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.palette.ChoreographyPalette;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.artifacts.TextAnnotation;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.choreography.ChoreographyTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.SequenceFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.Message;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.EndMessageEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.EndNoneEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.IntermediateCatchingMessageEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.IntermediateCatchingTimerEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.IntermediateThrowingMessageEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.StartTimerEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.StartTopLevelMessageEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.StartTopLevelNoneEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.TerminateEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways.EventBasedGateway;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways.ExclusiveGateway;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways.ParallelGateway;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNChoreographyDiagram;
import com.google.gwt.core.client.GWT;

public class ChoreographyPanel extends CollaborationPanel{
	
	private IEditorModel editorModel;
	
	public ChoreographyPanel(int width,int height) {
		super(width, height, false);
		
		this.palette = new ChoreographyPalette(this);
	}
	
	@Override
	public HashSet<Class<? extends IDraggableElement>> getAcceptedTypes() {
		
		HashSet<Class<? extends IDraggableElement>> result = super.getAcceptedTypes();
		
		//CHOREOGRAPHY
		result.add(ChoreographyTask.class);

		//EVENTS
		result.add(StartTopLevelNoneEvent.class);
		result.add(StartTopLevelMessageEvent.class);
		result.add(StartTimerEvent.class);
		result.add(IntermediateCatchingMessageEvent.class);
		result.add(IntermediateCatchingTimerEvent.class);
		result.add(IntermediateThrowingMessageEvent.class);
		result.add(EndNoneEvent.class);
		result.add(EndMessageEvent.class);
		result.add(TerminateEvent.class);
		
		//GATEWAYS
		result.add(ExclusiveGateway.class);
		result.add(ParallelGateway.class);
		result.add(EventBasedGateway.class);
		
		//CONNECTORS
		result.add(SequenceFlow.class);
		
		//DATA
		result.add(Message.class);
		
		//Artifacts
		result.add(TextAnnotation.class);
		
		return result;
	}
	
	@Override
	public HashSet<IDiagramViewConformityRule> getConformityRules() {
		
		HashSet<IDiagramViewConformityRule> result = new HashSet<IDiagramViewConformityRule>();
		
		DescriptiveProcessRules dpr = new DescriptiveProcessRules(this);
		
		result.add(dpr.new ProcessCannotBeEmpty(this));
		result.add(dpr.new ProcessShouldEndWithEndEvent());
		result.add(dpr.new ProcessShouldStartWithStartEvent());
		result.add(dpr.new ProcessWithEndEventMustHaveAStartEvent());
		result.add(dpr.new ProcessWithStartEventMustHaveAEndEvent());
		
		return result;
	}
	
	@Override
	public IEditorModel getEditorModel() {
		
		if (editorModel==null){
			editorModel = GWT.create(ChoreographyEditorModel.class);
		}
		
		return editorModel;
	}
	
	
	public IDiagram getDiagram() {
		
		if (bpmnDiagram==null){
			bpmnDiagram = GWT.create(BPMNChoreographyDiagram.class);
		}
		
		return bpmnDiagram;
	}
}
