/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.CommonEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.event.MessageEventEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.event.TimerEditorModel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.EventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.IntermediateCatchEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.IntermediateThrowEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.StartEventBean;

public class EventSyntaxModelBinder {
	
	private Event event;
	private IModelElement diagramElementSyntaxModel;
	private IEditorModel editorModel;
	private IDiagramElement diagramElement;
	
	public EventSyntaxModelBinder(Event event) {
		this.event = event;
	}
	
	public void bindSyntaxModel(IModelElement diagramElementSyntaxModel,
			IEditorModel editorModel, IDiagramElement diagramElement) {
		
		
		this.diagramElementSyntaxModel = diagramElementSyntaxModel;
		this.editorModel = editorModel;
		this.diagramElement = diagramElement;
	
		
		if (event instanceof StartTopLevelNoneEvent || event instanceof EndNoneEvent || event instanceof TerminateEvent){
			
			commonBind();
			
		}else if (event instanceof StartTopLevelMessageEvent){
			
			startMessageBind();
			
		}else if (event instanceof StartTimerEvent){
			
			startTimerBind();
			
		}else if (event instanceof IntermediateThrowingMessageEvent){
			
			intermediateThrowingMessageBind();
			
			
		}else if (event instanceof IntermediateCatchingMessageEvent){
			
			intermediateCatchingMessageBind();
			
		}else if (event instanceof IntermediateCatchingTimerEvent){
			
			intermediateCatchingTimerBind();
			
		}else if (event instanceof EndMessageEvent){
			
			endMessageBind();
			
		}
		
		
		
		
		
	}
	
	private void startMessageBind(){
		commonBind();
		
		StartEventBean startEventBean = (StartEventBean) this.diagramElementSyntaxModel;
		MessageEventEditorModel startMessageEditorModel = (MessageEventEditorModel)  this.editorModel;
		
		
		
		if (startMessageEditorModel.getMessageEventDefinition()!=null){
			startEventBean.getTriggers().clear();
			startEventBean.getTriggers().add(startMessageEditorModel.getMessageEventDefinition());
		}
			
		
	
	}

	private void startTimerBind(){
		commonBind();
		
		StartEventBean startEventBean = (StartEventBean) this.diagramElementSyntaxModel;
		
		TimerEditorModel startTimerEditorModel = (TimerEditorModel) this.editorModel;
		
		if (startTimerEditorModel.getTimerEventDefinition()!=null){
			startEventBean.getTriggers().clear();
			startEventBean.getTriggers().add(startTimerEditorModel.getTimerEventDefinition());
		}
		
	}
	
	private void intermediateThrowingMessageBind(){
		commonBind();		
		
		IntermediateThrowEventBean iteb = (IntermediateThrowEventBean) this.diagramElementSyntaxModel;
		
		MessageEventEditorModel model = (MessageEventEditorModel) this.editorModel;
		
		if (model.getMessageEventDefinition()!=null){
			
			iteb.getResults().clear();
			iteb.getResults().add(model.getMessageEventDefinition());
			
		}
		
	}
	
	
	private void intermediateCatchingMessageBind(){
		commonBind();
		
		IntermediateCatchEventBean iceb = (IntermediateCatchEventBean) this.diagramElementSyntaxModel;
		
		MessageEventEditorModel model = (MessageEventEditorModel) this.editorModel;
		
		if (model.getMessageEventDefinition()!=null){
			iceb.getTriggers().clear();
			iceb.getTriggers().add(model.getMessageEventDefinition());
		}
			
		
	}
	
	private void intermediateCatchingTimerBind(){
		commonBind();
		
		IntermediateCatchEventBean iceb = (IntermediateCatchEventBean) this.diagramElementSyntaxModel;
		
		TimerEditorModel model = (TimerEditorModel) this.editorModel;
		
		if (model.getTimerEventDefinition()!=null){
			iceb.getTriggers().clear();
			iceb.getTriggers().add(model.getTimerEventDefinition());
		}
			
	}
	

	
	private void endMessageBind(){
		commonBind();
		
		EndEventBean endEventBean = (EndEventBean) this.diagramElementSyntaxModel;
		
		MessageEventEditorModel model = (MessageEventEditorModel) this.editorModel;
		
		if (model.getMessageEventDefinition()!=null){
			endEventBean.getResults().clear();
			endEventBean.getResults().add(model.getMessageEventDefinition());
		}
			
		
	}
	

	
	private void commonBind(){
		
		EventBean event = (EventBean) this.diagramElementSyntaxModel;
		
		CommonEditorModel commonEditorModel = (CommonEditorModel) this.editorModel;
		
		event.setName(commonEditorModel.getName());
		event.setDocumentation(commonEditorModel.getDocumentation());
		
		
	}





}
