/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleLevel;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.AbstractDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleLevel;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.SequenceFlow;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.EventBasedGatewayBean;

public class DescriptiveProcessGatewayRules {
	
	private Gateway gateway;
	
	private HashSet<IDiagramElementViewConformityRule> rules;
	
	public DescriptiveProcessGatewayRules(Gateway gateway) {
		
		this.gateway = gateway;
		
		this.rules = new HashSet<IDiagramElementViewConformityRule>();
		
		this.rules.add(new GatewayMustHaveAtLeastOneOrTwoIncomingOrOutgoingSequenceFlow(gateway));
		
	}
	
	public HashSet<IDiagramElementViewConformityRule> getRules() {
		return rules;
	}
	
	
	//////Gateway must have at least one re two incoming or outgoing sequence flow
	private class GatewayMustHaveAtLeastOneOrTwoIncomingOrOutgoingSequenceFlow extends AbstractDiagramElementViewConformityRule{

		public GatewayMustHaveAtLeastOneOrTwoIncomingOrOutgoingSequenceFlow(
				IDiagramElementView diagramElementView) {
			super(diagramElementView);

		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			
			if (hasOneIncomingSequenceFlow(diagramElementView)&&hasMultipleOutgoingSequenceFlow(diagramElementView)){
				return true;
			}
			
			if (hasMultipleIncommingSequenceFlow(diagramElementView)&&hasOneOutgoingSequenceFlow(diagramElementView)){
				return true;
			}
			
			if (hasMultipleIncommingSequenceFlow(diagramElementView)&&hasMultipleOutgoingSequenceFlow(diagramElementView)){
				return true;
			}
			
			return false;
		}
		
		
		private boolean hasMultipleIncommingSequenceFlow(IDiagramElementView view){
			
			IConnectableElement connectable = (IConnectableElement) view;
			
			int i = 0;
			
			for(IConnector c:connectable.getIncommingConnectors()){
				
				if (c instanceof SequenceFlow){
					i++;
				}else{
					return false;
				}
				
			}
			
			if (i>1){
				return true;
			}
			
			return false;
		}
		
		private boolean hasMultipleOutgoingSequenceFlow(IDiagramElementView view){
			IConnectableElement connectable = (IConnectableElement) view;
			
			int i = 0;
			
			for(IConnector c:connectable.getOutgoingConnectors()){
				
				if (c instanceof SequenceFlow){
					i++;
				}else{
					return false;
				}
				
			}
			
			if (i>1){
				return true;
			}
			
			return false;
		}
		
		private boolean hasOneIncomingSequenceFlow(IDiagramElementView view){
			IConnectableElement connectable = (IConnectableElement) view;
			int i = 0;
			
			for(IConnector c:connectable.getIncommingConnectors()){
				
				if (c instanceof SequenceFlow){
					i++;
				}else{
					return false;
				}
				
			}
			
			if (i==1){
				return true;
			}
			
			return false;
		}
		
		private boolean hasOneOutgoingSequenceFlow(IDiagramElementView view){
			IConnectableElement connectable = (IConnectableElement) view;
			int i = 0;
			
			for(IConnector c:connectable.getOutgoingConnectors()){
				
				if (c instanceof SequenceFlow){
					i++;
				}else{
					return false;
				}
				
			}
			
			if (i==1){
				return true;
			}
			
			return false;
		}
		
		@Override
		public boolean canResolveNonConformity() {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public String getRuleDescription() {
			return "An Gateway must split (multiple outgoing sequence flows) or merge (multiple incoming sequence flows) or do both on a flow";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "No Split or Merge behavior detected";
		}

		@Override
		public void resolveNonConformity() {
			// TODO Auto-generated method stub
			
		}
		
		
		
	}
	
	
	///////////Event Based Gateway///////////////
	private class EventBasedGatewayMissingProperties implements IDiagramElementViewConformityRule{
		
		private IDiagramElementView diagramElementView;
		
		@Override
		public IDiagramElementView getNonConformElement() {
			

			
			return null;
		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			
			this.diagramElementView = diagramElementView;
			
			EventBasedGatewayBean bean = (EventBasedGatewayBean) this.diagramElementView.getDiagramElement().getModelElement();
			
			
			return false;
		}

		@Override
		public boolean canResolveNonConformity() {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public String getRuleDescription() {
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public IRuleLevel getRuleLevel() {
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public String getRuleName() {
			return "Missing properties";
		}

		@Override
		public void resolveNonConformity() {
			// TODO Auto-generated method stub
			
		}
		
		
		
	}
	
}
