/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.CommonEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.gateway.EventBasedGatewayEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.gateway.ExclusiveGatewayEditorModel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.EventBasedGatewayBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.ExclusiveGatewayBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.GatewayBean;

public class GatewaySyntaxModelBinder{
	
	private Gateway gateway;
	private IModelElement diagramElementSyntaxModel;
	private IEditorModel editorModel;
	private IDiagramElement diagramElement;
	
	public GatewaySyntaxModelBinder(Gateway gateway) {
		this.gateway = gateway;
	}
	
	public void bindSyntaxModel(IModelElement diagramElementSyntaxModel,
			IEditorModel editorModel, IDiagramElement diagramElement) {
		
		this.diagramElementSyntaxModel = diagramElementSyntaxModel;
		this.editorModel = editorModel;
		this.diagramElement = diagramElement;
		
		if (gateway instanceof ExclusiveGateway){
			
			exclusiveBind();
			
		}else if (gateway instanceof ParallelGateway){
			
			commonBind();
			
		}else if (gateway instanceof EventBasedGateway){
			
			eventBasedBind();
			
		}
		
	}
	
	private void commonBind() {
		
		GatewayBean gatewayBean 			= (GatewayBean) this.diagramElementSyntaxModel;
		CommonEditorModel commonEditorModel = (CommonEditorModel) this.editorModel;
		
		gatewayBean.setName(commonEditorModel.getName());
		gatewayBean.setDocumentation(commonEditorModel.getDocumentation());
		
	}
	

	private void exclusiveBind(){
		commonBind();
		
		ExclusiveGatewayBean exclusiveGatewayBean = (ExclusiveGatewayBean) this.diagramElementSyntaxModel;
		ExclusiveGatewayEditorModel editorModel = (ExclusiveGatewayEditorModel) this.editorModel;
		
		exclusiveGatewayBean.setDefaultSequenceFlow(editorModel.getDefaultSequenceFlow());
		
	}
	
	private void eventBasedBind(){
		commonBind();
		
		EventBasedGatewayBean eventBasedGatewayBean = (EventBasedGatewayBean) this.diagramElementSyntaxModel;
		EventBasedGatewayEditorModel editorModel = (EventBasedGatewayEditorModel) this.editorModel;
		
		eventBasedGatewayBean.setInstantiate(editorModel.isInstantiate());
		eventBasedGatewayBean.setType(editorModel.getType());
	}





	
	
}
