/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.usecase.descriptiveprocess;

import com.ebmwebsourcing.geasytools.diagrameditor.DiagramController;
import com.ebmwebsourcing.geasytools.diagrameditor.helper.designer.DiagramDesigner;
import com.ebmwebsourcing.geasytools.diagrameditor.helper.designer.DiagramElementProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration.Pool;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.DescriptiveProcessRules.HavingExpandedProcessExcludeHavingFlowNodesOnProcessPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.DescriptiveProcessRules.ProcessCannotBeEmpty;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.DescriptiveProcessRules.ProcessShouldEndWithEndEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.DescriptiveProcessRules.ProcessShouldStartWithStartEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.DescriptiveProcessRules.ProcessWithEndEventMustHaveAStartEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.DescriptiveProcessRules.ProcessWithStartEventMustHaveAEndEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.EndNoneEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.StartTopLevelNoneEvent;

public class DescriptiveProcessRulesTest extends DiagramDesigner{

	public DescriptiveProcessRulesTest(DiagramController controller) {
		super(controller);
		
		assert ((ProcessPanel)controller.getDiagramView()).isExecutableProcess()==false : "Use case is only for non-executable process";
		

		//PROCESS CANNOT BE EMPTY
		this.assertDiagramIsNotConformToRule(ProcessCannotBeEmpty.class);
		DiagramElementProxy<?> start = this.dropElement(StartTopLevelNoneEvent.class, 10, 10);
		this.assertDiagramIsConformToRule(ProcessCannotBeEmpty.class);
		
		
		//Having Expanded Process Exclude Having FlowNodes On ProcessPanel
		this.assertDiagramIsConformToRule(HavingExpandedProcessExcludeHavingFlowNodesOnProcessPanel.class);
		DiagramElementProxy<?> poolElement = this.dropElement(Pool.class, 100, 100);
		this.assertDiagramIsNotConformToRule(HavingExpandedProcessExcludeHavingFlowNodesOnProcessPanel.class);
		
		//PROCESS WITH A START EVENT MUST HAVE A END EVENT
		this.delete(poolElement);
		this.assertDiagramElementsCount(1);
		this.assertDiagramIsNotConformToRule(ProcessWithStartEventMustHaveAEndEvent.class);

		//PROCESS WITH AN END EVENT MUST HAVE A START EVENT
		this.delete(start);
		this.assertDiagramElementsCount(0);		
		DiagramElementProxy<?> end = this.dropElement(EndNoneEvent.class, 100, 100);
		this.assertDiagramIsNotConformToRule(ProcessWithEndEventMustHaveAStartEvent.class);
		
		//Check that we are conform with the two previous rules
		DiagramElementProxy<?> start2  = this.dropElement(StartTopLevelNoneEvent.class, 10, 10);
		this.assertDiagramIsConformToRule(ProcessWithStartEventMustHaveAEndEvent.class);
		this.assertDiagramIsConformToRule(ProcessWithEndEventMustHaveAStartEvent.class);
		
		//Assert that two previous rules are respected
		this.assertDiagramIsConformToRule(ProcessShouldStartWithStartEvent.class);
		this.assertDiagramIsConformToRule(ProcessShouldEndWithEndEvent.class);
		
		//PROCESS SHOULD START WITH START EVENT
		this.delete(start2);
		this.assertDiagramElementsCount(1);
		this.assertDiagramIsNotConformToRule(ProcessShouldStartWithStartEvent.class);
	
		//PROCESS SHOULD END WITH END EVENT
		this.delete(end);
		this.assertDiagramElementsCount(0);
		this.assertDiagramIsNotConformToRule(ProcessShouldEndWithEndEvent.class);
		
		//PROCESS CANNOT BE EMPTY
		this.assertDiagramIsNotConformToRule(ProcessCannotBeEmpty.class);
		
	}
	
	
	

}
