/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.activity.binder;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.Binder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.IHasReflectionProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.activity.ServiceTaskEditorModel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.Constants.TaskType;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ServiceTaskBean;

@Binder(bindedModel = ServiceTaskBean.class, watchedModel = ServiceTaskEditorModel.class
		,watchedModelIgnoredFields={"taskType","editorModelProvider"})
public abstract class ServiceTaskBinder implements IBinder<ServiceTaskEditorModel, ServiceTaskBean>{

	
	@Override
	public void initializeWatchedModel(ServiceTaskEditorModel watchedModel,
			ServiceTaskBean modelToBind) {
		
		//do not use setType setter as context is not yet initialized
		IHasReflectionProxy hr = (IHasReflectionProxy) watchedModel;
		hr.setFieldValue("taskType", TaskType.SERVICE_TASK);
		
		
	}
	
}
