/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.connector.binder;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.Binder;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.connector.SequenceFlowEditorModel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IExpressionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data.ExpressionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;


@Binder(bindedModel = SequenceFlowBean.class, watchedModel = SequenceFlowEditorModel.class,watchedModelIgnoredFields="conditionnalExpression")
public abstract class SequenceFlowBinder implements IBinder<SequenceFlowEditorModel, SequenceFlowBean>{

	@Override
	public void bind(SequenceFlowEditorModel watchedModel,
			SequenceFlowBean modelToBind) {
		IExpressionBean exp = new ExpressionBean();
		exp.setContent(watchedModel.getConditionnalExpression());
		modelToBind.setExpression(exp);
	}
	
	
	@Override
	public void initializeWatchedModel(SequenceFlowEditorModel watchedModel,
			SequenceFlowBean modelToBind) {
		if(modelToBind.getExpression()!=null) {
			watchedModel.setConditionnalExpression(modelToBind.getExpression().getContent());
		}
	}
	
}
