/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.data;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.ModelBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.annotation.Observable;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.annotation.Editor;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.annotation.Editor.Widget;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.CommonEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.CommonTemplate;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.data.binder.MessageBinder;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.widget.ItemDefinitionListInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;

@Editor(template=CommonTemplate.class)
@ModelBinder(binder=MessageBinder.class)
@Observable(handlers=MessageObservableHandler.class)
public class MessageEditorModel extends CommonEditorModel{

	@Widget(order=4,label = "Item definition",instantiationHandler=ItemDefinitionListInstantiationHandler.class)
	private IItemDefinitionBean itemDefinition;
	
	@Widget(order=5,label ="Is initiating")
	private boolean initiating = true;
	
	public IItemDefinitionBean getItemDefinition() {
		return itemDefinition;
	}
	public void setItemDefinition(IItemDefinitionBean itemDefinition) {
		this.itemDefinition = itemDefinition;
	}
	public boolean isInitiating() {
		return initiating;
	}
	public void setInitiating(boolean initiating) {
		this.initiating = initiating;
	}
	
	
	
	
}