/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.event.binder;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.Binder;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.event.StartMessageEditorModel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.IMessageEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.definition.MessageEventDefinitionBean;

@Binder(bindedModel = StartEventBean.class, watchedModel = StartMessageEditorModel.class,watchedModelIgnoredFields="messageEventDefinition")
public abstract class StartMessageBinder implements IBinder<StartMessageEditorModel, StartEventBean>{

	
	@Override
	public void onInstantiation(StartMessageEditorModel watchedModel,
			StartEventBean modelToBind) {
		MessageEventDefinitionBean ted = new MessageEventDefinitionBean();
		modelToBind.addTrigger(ted);
	}	

	@Override
	public void initializeWatchedModel(StartMessageEditorModel watchedModel,
			StartEventBean modelToBind) {
		if(modelToBind.getTriggers()!=null && !modelToBind.getTriggers().isEmpty()) {
			watchedModel.setMessageEventDefinition((IMessageEventDefinitionBean) modelToBind.getTriggers().get(0));
		}
	}
	
	@Override
	public void bind(StartMessageEditorModel watchedModel, StartEventBean modelToBind) {
	    if(watchedModel.getMessageEventDefinition()!=null) {
    	    modelToBind.getTriggers().clear();
    	    modelToBind.addTrigger(watchedModel.getMessageEventDefinition());
	    }
	}
	
}
