/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.swimlane;

import java.util.List;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.ModelBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.annotation.Observable;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.annotation.Editor;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.annotation.Editor.Widget;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.CommonEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.swimlane.binder.PoolBinder;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.template.PoolTemplate;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.widget.InterfacesWidgetInstantationHandler;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;

@Editor(template=PoolTemplate.class)
@ModelBinder(binder=PoolBinder.class)
@Observable(handlers=PoolObservableHandler.class)
public class PoolEditorModel extends CommonEditorModel {
	

//	private ArrayList<String> partnerRoleIds;
	
	@Widget(order=2,label="Interfaces",instantiationHandler=InterfacesWidgetInstantationHandler.class)
	private List<IInterfaceBean> interfaces;
	
	@Widget(order=3,label="Min. Multiplicity")
	private int minimumMultiplicity;
	
	@Widget(order=4,label="Max. Multiplicity")
	private int maximumMultiplicity;
	
	@Widget(order=5,label="Initiating")
	private boolean initiating;
	
	public int getMinimumMultiplicity() {
		return minimumMultiplicity;
	}

	public void setInitiating(boolean initiating) {
		this.initiating = initiating;
	}
	
	public boolean isInitiating() {
		return initiating;
	}

	public void setMinimumMultiplicity(int minimumMultiplicity) {
		this.minimumMultiplicity = minimumMultiplicity;
	}



	public int getMaximumMultiplicity() {
		return maximumMultiplicity;
	}



	public void setMaximumMultiplicity(int maximumMultiplicity) {
		this.maximumMultiplicity = maximumMultiplicity;
	}


//	public void setPartnerRoleIds(ArrayList<String> partnerRoleIds) {
//		this.partnerRoleIds = partnerRoleIds;
//	}
	
	public List<IInterfaceBean> getInterfaces() {
		return interfaces;
	}
	
	public void setInterfaces(List<IInterfaceBean> interfaces) {
		this.interfaces = interfaces;
	}
	
	
//	public ArrayList<String> getPartnerRoleIds() {
//		return partnerRoleIds;
//	}
	


	
	
}
