/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.swimlane.binder;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.lookup.IHasLookupProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.Binder;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.swimlane.PoolEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.choreography.Participant;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.choreography.Participant.ParticipantLevel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.ParticipantBandKind;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNShape;

@Binder(bindedModel = ParticipantBean.class,watchedModel=PoolEditorModel.class,watchedModelIgnoredFields="initiating")
public abstract class PoolBinder implements IBinder<PoolEditorModel, ParticipantBean>{
	
	

	@Override
	public void initializeWatchedModel(PoolEditorModel watchedModel,
			ParticipantBean modelToBind) {
		
		IHasLookupProxy lookupProxy = (IHasLookupProxy) watchedModel;
		
		Participant participant = (Participant) lookupProxy.lookup(Participant.class);	
		
		if (participant!=null){

			BPMNShape shape = (BPMNShape) participant.getDiagramElement();
			
			if (shape.getParticipantBandKind()==ParticipantBandKind.top_initiating||
				shape.getParticipantBandKind()==ParticipantBandKind.middle_initiating||
				shape.getParticipantBandKind()==ParticipantBandKind.bottom_initiating){
				watchedModel.setInitiating(true);
			}else{
				watchedModel.setInitiating(false);
			}
			
		}
		
	}

	
	@Override
	public void bind(PoolEditorModel watchedModel, ParticipantBean modelToBind) {
		
		IHasLookupProxy lookupProxy = (IHasLookupProxy) watchedModel;
		
		Participant participant = (Participant) lookupProxy.lookup(Participant.class);	
		
		if (participant!=null){
			
			BPMNShape shape 				= (BPMNShape) participant.getDiagramElement();
			PoolEditorModel poolEditorModel = (PoolEditorModel) participant.getEditorModel();	
			
			if (poolEditorModel.isInitiating() && participant.getLevel()==ParticipantLevel.TOP){
				shape.setParticipantBandKind(ParticipantBandKind.top_initiating);
			}else if (poolEditorModel.isInitiating() && participant.getLevel()==ParticipantLevel.MIDDLE){
				shape.setParticipantBandKind(ParticipantBandKind.middle_initiating);				
			}else if (poolEditorModel.isInitiating() && participant.getLevel()==ParticipantLevel.BOTTOM){
				shape.setParticipantBandKind(ParticipantBandKind.bottom_initiating);
			}else if (poolEditorModel.isInitiating()==false && participant.getLevel()==ParticipantLevel.TOP){
				shape.setParticipantBandKind(ParticipantBandKind.top_non_initiating);
			}else if (poolEditorModel.isInitiating()==false && participant.getLevel()==ParticipantLevel.MIDDLE){
				shape.setParticipantBandKind(ParticipantBandKind.middle_non_initiating);				
			}else if (poolEditorModel.isInitiating()==false && participant.getLevel()==ParticipantLevel.BOTTOM){
				shape.setParticipantBandKind(ParticipantBandKind.bottom_non_initiating);
			}
		
		}	
	
	}

}
