/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.template;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.lookup.IHasLookupProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.template.DefaultTemplateHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.DefaultTask;

public class TaskTemplateHandler implements DefaultTemplateHandler{
	
	private TaskTemplate taskTemplate;
	
	public TaskTemplateHandler(TaskTemplate taskTemplate) {
		this.taskTemplate = taskTemplate;
	}
	
	public TaskTemplate getTaskTemplate() {
		return taskTemplate;
	}
	
	
	@Override
	public boolean load(String fieldName) {
		
		IEditorModel editorModel = (IEditorModel) this.getTaskTemplate().getEditorModel();
		
		IHasLookupProxy lookupProxy = (IHasLookupProxy) editorModel;
		
		DefaultTask task = (DefaultTask) lookupProxy.lookup(DefaultTask.class);
		
		boolean isExec = task.getDefinitionPanel().isExecutableProcess();
		
		if (isExec){
			
			if (fieldName.equals("message")|| fieldName.equals("operation") || fieldName.equals("instantiate")){
				return true;
			}
			
			
		}else{
			
			if (fieldName.equals("message")|| fieldName.equals("operation") || fieldName.equals("instantiate")){
				return false;
			}			
		}
		
		return true;
	}

}
