/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.widget;

import java.util.List;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.IHasEditor;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.IWidgetInstantiationHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.MultipleChoiceListUIField;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.BeforeDisplayEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.DisplayEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.IUIFieldHandler;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;

public class InterfacesWidgetInstantationHandler implements IWidgetInstantiationHandler<MultipleChoiceListUIField<List<IInterfaceBean>, IInterfaceBean>>{
	
	private IDefinitionsBean defs;
	private IHasEditor hasEditor;
	
	@Override
	public MultipleChoiceListUIField<List<IInterfaceBean>, IInterfaceBean> instantiate() {
		
		final MultipleChoiceListUIField<List<IInterfaceBean>, IInterfaceBean> m = new MultipleChoiceListUIField<List<IInterfaceBean>, IInterfaceBean>(null);

		m.addUIFieldHandler(new IUIFieldHandler() {
			
			@Override
			public void onDisplay(DisplayEvent event) {
				
				
				m.setOptions(defs.getInterfaces());
				
			}

			@Override
			public void onBeforeDiplay(BeforeDisplayEvent event) {
				// TODO Auto-generated method stub
				
			}
		});
		
		return m;
	}

	@Override
	public void setDataProvider(Object dataProvider) {
		this.defs = (IDefinitionsBean) dataProvider;
	}

	@Override
	public void setEditorModel(IHasEditor model) {
		this.hasEditor = model;
	}




}
