/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.palette;

import com.ebmwebsourcing.geasytools.diagrameditor.impl.graphic.DiagramElementViewInstantiationHandlerRegistry;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.palette.Palette;
import com.ebmwebsourcing.geasytools.geasyui.impl.palette.PaletteGroup;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.activities.BusinessRuleTaskDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.activities.CallActivityDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.activities.ManualTaskDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.activities.ReceiveTaskDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.activities.ScriptTaskDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.activities.SendTaskDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.activities.ServiceTaskDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.activities.TaskDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.activities.UserTaskDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.artifact.TextAnnotationDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.collaboration.CollapsedPoolDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.collaboration.LaneDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.collaboration.PoolDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.connectors.DataAssociationDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.connectors.MessageFlowDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.connectors.SequenceFlowDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.data.DataInputDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.data.DataObjectDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.data.DataOutputDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.data.MessageDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.EndMessageDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.EndNoneDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.IntermediateCatchingMessageDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.IntermediateCatchingTimerDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.IntermediateThrowingMessageDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.StartTopLevelMessageDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.StartTopLevelNoneDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.StartTopLevelTimerDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.TerminateDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.gateways.EventBasedGatewayDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.gateways.ExclusiveGatewayDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.gateways.ParallelGatewayDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.BusinessRuleTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.BusinessRuleTaskInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.CallActivity;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.CallActivityInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.DefaultTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.ManualTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.ManualTaskInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.ReceiveTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.ReceiveTaskInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.ScriptTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.ScriptTaskInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.SendTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.SendTaskInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.ServiceTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.ServiceTaskInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.TaskInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.UserTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.UserTaskInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.artifacts.TextAnnotation;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.artifacts.TextAnnotationInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration.CollapsedPool;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration.Lane;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration.LaneInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration.Pool;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration.PoolInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration.PoolInstantiationHandler.ParticipantType;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.Association;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.AssociationInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.DataAssociation;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.DataAssociationInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.MessageFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.MessageFlowInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.SequenceFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.SequenceFlowInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.DataInput;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.DataInputInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.DataObject;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.DataObjectInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.DataOutput;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.DataOutputInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.Message;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.MessageInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.EndMessageEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.EndMessageEventInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.EndNoneEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.EndNoneEventInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.IntermediateCatchingMessageEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.IntermediateCatchingMessageEventInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.IntermediateCatchingTimerEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.IntermediateCatchingTimerEventInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.IntermediateThrowingMessageEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.IntermediateThrowingMessageEventInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.StartMessageEventInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.StartTimerEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.StartTimerEventInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.StartTopLevelMessageEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.StartTopLevelNoneEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.StartTopLevelNoneEventInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.TerminateEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.TerminateEventInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways.EventBasedGateway;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways.EventBasedGatewayInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways.ExclusiveGateway;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways.ExclusiveGatewayInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways.ParallelGateway;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways.ParallelGatewayInstantiationHandler;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.MessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.MessageFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.artifact.AssociationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.artifact.TextAnnotationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.BusinessRuleTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.CallActivityBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ManualTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ReceiveTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ScriptTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.SendTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ServiceTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.TaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.UserTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data.DataAssociationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data.DataInputBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data.DataObjectBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data.DataOutputBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.IntermediateCatchEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.IntermediateThrowEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.EventBasedGatewayBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.ExclusiveGatewayBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.ParallelGatewayBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;

public class ProcessPalette extends Palette {
	
	//containers
	protected PaletteGroup containersGroup;
	
	protected CollapsedPoolDragProxy collapsedPoolDragProxy;
	protected PoolDragProxy poolDragProxy;
	protected LaneDragProxy laneDragProxy;
	
	
	//activities
	protected PaletteGroup activitiesGroup;
	
	protected TaskDragProxy taskDragProxy;
	protected CallActivityDragProxy callActivityDragProxy;
	protected ServiceTaskDragProxy serviceTaskDragProxy;
	protected SendTaskDragProxy sendTaskDragProxy;
	protected ReceiveTaskDragProxy receiveTaskDragProxy;
	protected ManualTaskDragProxy manualTaskDragProxy;
	protected BusinessRuleTaskDragProxy businessRuleTaskDragProxy;
	protected ScriptTaskDragProxy scriptTaskDragProxy;
	protected UserTaskDragProxy userTaskDragProxy;
	
	//events
	protected PaletteGroup eventsGroup;

	protected StartTopLevelNoneDragProxy evdp1;
	protected StartTopLevelMessageDragProxy evdp2;
	protected StartTopLevelTimerDragProxy stltdp;
	protected IntermediateThrowingMessageDragProxy itmdp;
	protected IntermediateCatchingMessageDragProxy icmdp;
	protected IntermediateCatchingTimerDragProxy ictdp;
	protected EndNoneDragProxy evdp3;
	protected EndMessageDragProxy evdp4;
	protected TerminateDragProxy terminatedp;
	
	
	//gateways
	protected PaletteGroup gatewaysGroup;
	
	protected ExclusiveGatewayDragProxy gwydp1;
	protected ParallelGatewayDragProxy gwydp2;
	protected EventBasedGatewayDragProxy gwydp3;
	
	
	//data
	protected PaletteGroup dataGroup;
	
	protected DataObjectDragProxy dataDragProxy;
	protected DataInputDragProxy dataInputDP;
	protected DataOutputDragProxy dataOutputDP;	
	protected MessageDragProxy messageDP;
	
	//connections
	protected PaletteGroup connectorsGroup;

	protected SequenceFlowDragProxy sfDragProxy;
	protected MessageFlowDragProxy mfdp;
	protected DataAssociationDragProxy dadp;

	//artifacts
	protected PaletteGroup artifactsGroup;
	
	protected TextAnnotationDragProxy tadp;
	
	public ProcessPalette(IUIPanel uipanel) {
		super(uipanel);
		
		//containers 
		containersGroup = new PaletteGroup("Swimlanes");
		
		collapsedPoolDragProxy  = new CollapsedPoolDragProxy(uipanel);
		poolDragProxy			= new PoolDragProxy(uipanel);
		laneDragProxy			= new LaneDragProxy(uipanel);
		
		containersGroup.addElement(collapsedPoolDragProxy);
		containersGroup.addElement(poolDragProxy);
		containersGroup.addElement(laneDragProxy);
		
		//activities
		activitiesGroup = new PaletteGroup("Activities");
		
		taskDragProxy 				=  new TaskDragProxy(uipanel);
		serviceTaskDragProxy 		= new ServiceTaskDragProxy(uipanel);
		sendTaskDragProxy 			= new SendTaskDragProxy(uipanel);
		receiveTaskDragProxy 		= new ReceiveTaskDragProxy(uipanel);
		manualTaskDragProxy			= new ManualTaskDragProxy(uipanel);
		userTaskDragProxy			= new UserTaskDragProxy(uipanel);
		scriptTaskDragProxy			= new ScriptTaskDragProxy(uipanel);
		businessRuleTaskDragProxy	= new BusinessRuleTaskDragProxy(uipanel);
		
		
		callActivityDragProxy = new CallActivityDragProxy(uipanel);
		
		activitiesGroup.addElement(taskDragProxy);
		activitiesGroup.addElement(serviceTaskDragProxy);
		activitiesGroup.addElement(sendTaskDragProxy);
		activitiesGroup.addElement(receiveTaskDragProxy);
		activitiesGroup.addElement(manualTaskDragProxy);
		activitiesGroup.addElement(userTaskDragProxy);
		activitiesGroup.addElement(scriptTaskDragProxy);
		activitiesGroup.addElement(businessRuleTaskDragProxy);
		activitiesGroup.addElement(callActivityDragProxy);
		
		//events
		eventsGroup = new PaletteGroup("Events");
		
		this.evdp1   		= new StartTopLevelNoneDragProxy(uipanel);
		this.evdp2 			= new StartTopLevelMessageDragProxy(uipanel);
		this.stltdp     	= new StartTopLevelTimerDragProxy(uipanel);
		this.itmdp 			= new IntermediateThrowingMessageDragProxy(uipanel);
		this.icmdp 			= new IntermediateCatchingMessageDragProxy(uipanel);
		this.ictdp    		= new IntermediateCatchingTimerDragProxy(uipanel);
		this.evdp3			= new EndNoneDragProxy(uipanel);
		this.evdp4			= new EndMessageDragProxy(uipanel);
		this.terminatedp	= new TerminateDragProxy(uipanel);
		
		eventsGroup.addElement(evdp1);
		eventsGroup.addElement(evdp2);
		eventsGroup.addElement(stltdp);
		eventsGroup.addElement(itmdp);
		eventsGroup.addElement(icmdp);
		eventsGroup.addElement(ictdp);
		eventsGroup.addElement(evdp3);
		eventsGroup.addElement(evdp4);
		eventsGroup.addElement(terminatedp);
		
		//Gateways
		gatewaysGroup = new PaletteGroup("Gateways");
		
		gwydp1	= new ExclusiveGatewayDragProxy(uipanel);
		gwydp2	= new ParallelGatewayDragProxy(uipanel);
		gwydp3	= new EventBasedGatewayDragProxy(uipanel);
		
		gatewaysGroup.addElement(gwydp1);
		gatewaysGroup.addElement(gwydp2);
		gatewaysGroup.addElement(gwydp3);
		
		//connectors
		connectorsGroup = new PaletteGroup("Connectors");
		
		sfDragProxy 	= new SequenceFlowDragProxy(uipanel);
		mfdp 			= new MessageFlowDragProxy(uipanel);
		dadp 			= new DataAssociationDragProxy(uipanel);
		
		connectorsGroup.addElement(sfDragProxy);
		connectorsGroup.addElement(mfdp);
		connectorsGroup.addElement(dadp);
		
		//Data
		dataGroup		= new PaletteGroup("Data");
		
		dataDragProxy 	= new DataObjectDragProxy(uipanel);
		dataInputDP	 	= new DataInputDragProxy(uipanel);
		dataOutputDP 	= new DataOutputDragProxy(uipanel);

		dataGroup.addElement(dataDragProxy);
		dataGroup.addElement(dataInputDP);
		dataGroup.addElement(dataOutputDP);

		//Artifacts
		artifactsGroup	= new PaletteGroup("Artifacts");
		
		tadp			= new TextAnnotationDragProxy(getUIPanel());
		
		artifactsGroup.addElement(tadp);
		
		this.appendGroup(containersGroup);
		this.appendGroup(activitiesGroup);
		this.appendGroup(eventsGroup);
		this.appendGroup(gatewaysGroup);
		this.appendGroup(connectorsGroup);
		this.appendGroup(dataGroup);
		this.appendGroup(artifactsGroup);
		
		init();
		
	}
	
	
	protected void init(){
		
		//TODO: Find a better way to force instantiation handlers registrations ...
		
		//DiagramElementView instantiation handler registration
		
		//activity
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(DefaultTask.class, TaskBean.class, new TaskInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(ServiceTask.class, ServiceTaskBean.class, new ServiceTaskInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(ReceiveTask.class, ReceiveTaskBean.class, new ReceiveTaskInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(SendTask.class, SendTaskBean.class, new SendTaskInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(ManualTask.class, ManualTaskBean.class, new ManualTaskInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(UserTask.class, UserTaskBean.class, new UserTaskInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(ScriptTask.class, ScriptTaskBean.class, new ScriptTaskInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(BusinessRuleTask.class, BusinessRuleTaskBean.class, new BusinessRuleTaskInstantiationHandler());
		
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(CallActivity.class,CallActivityBean.class,new CallActivityInstantiationHandler());

		//connector
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(SequenceFlow.class,SequenceFlowBean.class,new SequenceFlowInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(MessageFlow.class,MessageFlowBean.class,new MessageFlowInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(DataAssociation.class,DataAssociationBean.class,new DataAssociationInstantiationHandler());		
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(Association.class,AssociationBean.class,new AssociationInstantiationHandler());
		
		//swimlane
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(CollapsedPool.class,ParticipantBean.class,new PoolInstantiationHandler(ParticipantType.Collapsed));
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(Pool.class,ParticipantBean.class,new PoolInstantiationHandler(ParticipantType.Expanded));
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(Lane.class,LaneBean.class,new LaneInstantiationHandler());

		//events
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(StartTopLevelNoneEvent.class,StartEventBean.class,new StartTopLevelNoneEventInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(StartTopLevelMessageEvent.class,StartEventBean.class,new StartMessageEventInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(StartTimerEvent.class,StartEventBean.class,new StartTimerEventInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(IntermediateThrowingMessageEvent.class,IntermediateThrowEventBean.class,new IntermediateThrowingMessageEventInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(IntermediateCatchingMessageEvent.class,IntermediateCatchEventBean.class,new IntermediateCatchingMessageEventInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(IntermediateCatchingTimerEvent.class,IntermediateCatchEventBean.class,new IntermediateCatchingTimerEventInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(EndNoneEvent.class,EndEventBean.class,new EndNoneEventInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(EndMessageEvent.class,EndEventBean.class,new EndMessageEventInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(TerminateEvent.class,EndEventBean.class,new TerminateEventInstantiationHandler());
		
		//gateways
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(ExclusiveGateway.class,ExclusiveGatewayBean.class,new ExclusiveGatewayInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(ParallelGateway.class,ParallelGatewayBean.class,new ParallelGatewayInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(EventBasedGateway.class,EventBasedGatewayBean.class,new EventBasedGatewayInstantiationHandler());
		
		//DataObject
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(DataObject.class,DataObjectBean.class,new DataObjectInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(DataInput.class,DataInputBean.class,new DataInputInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(DataOutput.class,DataOutputBean.class,new DataOutputInstantiationHandler());
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(Message.class, MessageBean.class, new MessageInstantiationHandler());
		
		
		//Artifacts
		DiagramElementViewInstantiationHandlerRegistry.getInstance().registerDiagramElementViewInstantiationHandler(TextAnnotation.class, TextAnnotationBean.class, new TextAnnotationInstantiationHandler());
		
	}
	
	
}

