/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Path;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Rectangle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.BPMNElementsPath;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.activity.CallActivityEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;
import com.google.gwt.core.client.GWT;

public class CallActivity extends Activity {
	
	
	private Rectangle rectangle;
	private Path collapsedMarker;
	
	private CallActivityEditorModel editorModel;
	
	private String DEFAULT_LABEL = "Call Activity";
	

	
	public CallActivity(ProcessPanel definitionPanel,String id) {
		super(definitionPanel, id);
	}

	@Override
	public SVGElement getMainShape() {
		
		if (rectangle==null){
			rectangle = this.getDefinitionPanel().getCanvas().createRectangle(0, 0, 100, 50,5);
			rectangle.setFillColour("white");
			rectangle.setStokeColour("#A4376B");
			rectangle.getElement().setAttribute("stroke-width", "3");
		}
			
		return rectangle;
	}

	
	@Override
	protected void init() {
		super.init();
		
		this.label  = this.getDefinitionPanel().getCanvas().createText(50, 25, DEFAULT_LABEL);
		this.getGroup().appendChild(label);
		
		this.collapsedMarker = this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.ACTIVITY_MARKER_SUBPROCESS_COLLAPSED, 0, 0);
		this.collapsedMarker.setStokeColour("#A4376B");
		this.collapsedMarker.translate(40, 30);
		
		this.getGroup().appendChild(collapsedMarker);
	}
	
	

	@Override
	public Direction getMenuDirection() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getName() {
		return "Call Activity";
	}





	@Override
	public IEditorModel getEditorModel() {
		
		if (editorModel==null){
			this.editorModel = (CallActivityEditorModel) createEditorModel();
		}
		
		return editorModel;
	}


	@Override
	protected IEditorModel createEditorModel() {
		return GWT.create(CallActivityEditorModel.class);
	}


	@Override
	public void onDropRefused(IDropRefusedEvent event) {
		// TODO Auto-generated method stub

	}

	@Override
	public void onOut(IOutEvent event) {
		// TODO Auto-generated method stub

	}

	@Override
	public void onOver(IOverEvent event) {
		// TODO Auto-generated method stub

	}



}
