/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.artifacts;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleLevel;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.AbstractDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleLevel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.artifact.TextAnnotationEditorModel;

public class DescriptiveProcessArtifactRules {

	public HashSet<IDiagramElementViewConformityRule> getRules(TextAnnotation ta) {
		HashSet<IDiagramElementViewConformityRule> rules = new HashSet<IDiagramElementViewConformityRule>();

		rules.add(new TextAnnotationCannotBeEmpty(ta));
		
		return rules;
	}
	
	
	
	private class TextAnnotationCannotBeEmpty extends AbstractDiagramElementViewConformityRule {
		public TextAnnotationCannotBeEmpty(IDiagramElementView diagramElementView) {
			super(diagramElementView);
		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			TextAnnotationEditorModel em = (TextAnnotationEditorModel) diagramElementView.getEditorModel();
			return em.getText()!=null && !em.getText().trim().isEmpty();
		}

		@Override
		public boolean canResolveNonConformity() {
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "Please set the Text of the annotation.";
		}

		@Override
		public String getRuleDescription() {
			return "An annotation cannot be empty.";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "Empty text annotation.";
		}

		@Override
		public void resolveNonConformity() {
		
		}
	}
}
