/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.choreography;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleLevel;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.AbstractDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleLevel;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.Association;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.Message;

public class ParticipantRules {
	
	private HashSet<IDiagramElementViewConformityRule> rules;
	
	public ParticipantRules(Participant participant) {
		
		this.rules = new HashSet<IDiagramElementViewConformityRule>();
		
		this.rules.add(new AParticipantMessageMustHaveTheSameInitiatingStateOfTheAssociatedParticipant(participant));
		this.rules.add(new AParticipantCannotHaveMoreThan1AssociatedMessage(participant));
	
	}
	
	public HashSet<IDiagramElementViewConformityRule> getRules() {
		return rules;
	}
	
	/////////////////////
	//BPMN SPECIFICATION RULES: ERRORS
	///////////////////////
	
	
	////////////////A PARTICIPANT MESSAGE MUST HAVE THE SAME INITIATING STATE OF THE ASSOCIATED PARTICIPANT
	public class AParticipantMessageMustHaveTheSameInitiatingStateOfTheAssociatedParticipant extends AbstractDiagramElementViewConformityRule {

		public AParticipantMessageMustHaveTheSameInitiatingStateOfTheAssociatedParticipant(IDiagramElementView diagramElementView) {
			super(diagramElementView);
			
		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			
			
			Participant connectable = (Participant) diagramElementView;
			
			if (connectable.getOutgoingConnectors().size()>0){
				
				IConnector connector = connectable.getOutgoingConnectors().iterator().next();
				
				if (connector instanceof Association){
					
					IConnectableElement target = connector.getTarget();
					
					if (target instanceof Message){
						
						Message message = (Message) target;
						
						if (connectable.isInitiating()!=message.isInitiating()){
							return false;
						}
						
					}
					
				}
				
			}
			
			return true;
		}

		@Override
		public boolean canResolveNonConformity() {
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "Current participant's message does not have the same initiating state";
		}

		@Override
		public String getRuleDescription() {
			return "A participant message must have the same initiating state of the associated participant";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "Associated message initiating state";
		}

		@Override
		public void resolveNonConformity() {
		
		}
		
		
		
		
	}
	
	//////////////A PARTICIPANT CANNOT HAVE MORE THAN 1 ASSOCIATED MESSAGE
	public class AParticipantCannotHaveMoreThan1AssociatedMessage extends AbstractDiagramElementViewConformityRule {

		public AParticipantCannotHaveMoreThan1AssociatedMessage(IDiagramElementView diagramElementView) {
			super(diagramElementView);
			
		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			
			Participant connectable = (Participant) diagramElementView;
			
			int nb = 0;
			for(IConnector connector : connectable.getOutgoingConnectors()){
				
				if (connector instanceof Association && connector.getTarget() instanceof Message){
					nb++;
				}
				
			}
			
			if (nb>1){
				return false;
			}
			
			return true;
		}

		@Override
		public boolean canResolveNonConformity() {
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "Current participant have more than one associated message. Remove some of them.";
		}

		@Override
		public String getRuleDescription() {
			return "A participant cannot have more than one associated message";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "Too much associated message";
		}

		@Override
		public void resolveNonConformity() {
		
		}
		
	}	

	
}
