/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.swimlane.LaneEditorModel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.collaboration.ILaneBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.activity.ICallActivityBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.activity.ITaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataObjectBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IEndEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IIntermediateCatchEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IIntermediateThrowEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IStartEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.gateway.IGatewayBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.LaneSetBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNShape;

public class LaneSyntaxModelBinder {

	public void bindSyntaxModel(IModelElement diagramElementSyntaxModel,
			IEditorModel editorModel, IDiagramElement diagramElement) {
		
		LaneBean laneBean 				= (LaneBean) diagramElementSyntaxModel;
		LaneEditorModel laneEditorModel = (LaneEditorModel) editorModel;
		
		//Build Participant process
		IDiagramElement pool 			= diagramElement.getOwningElement();
//		ParticipantBean participantBean = (ParticipantBean) pool.getModelElement();
//		ProcessBuilder builder  		= new ProcessBuilder(diagramElement, participantBean.getProcess());
//		builder.build();
		
		
		
		laneBean.setName(laneEditorModel.getName());
		laneBean.setDocumentation(laneEditorModel.getDocumentation());
		
		//retrieve all elements that was added into lane
		BPMNShape laneShape = (BPMNShape) diagramElement;
		
		
		//clear all elements from laneBean as the previous ones may have been deleted
		laneBean.getCallActivities().clear();
		laneBean.getDataObjects().clear();
		laneBean.getEndEvents().clear();
		laneBean.getGateways().clear();
		laneBean.getIntermediateCatchEvents().clear();
		laneBean.getIntermediateThrowEvents().clear();
		laneBean.getStartEvents().clear();
		laneBean.getTasks().clear();
		if (laneBean.getChildLaneSet()!=null) laneBean.getChildLaneSet().getLanes().clear();
		
		//clear all elements from processBean as the previous ones may have been deleted
		
		
				for(IDiagramElement el:laneShape.getOwnedElements()){
					
					
					if (el.getModelElement() instanceof ICallActivityBean){
						
						//add call activity into lane
						laneBean.addCallActivity((ICallActivityBean) el.getModelElement());


					}else if (el.getModelElement() instanceof IDataObjectBean){
						
						//add data object into lane
						laneBean.addDataObject((IDataObjectBean) el.getModelElement());

						
					}else if (el.getModelElement() instanceof IEndEventBean){
						
						//add into lane
						laneBean.addEndEvent((IEndEventBean) el.getModelElement());
			
						

						
					}else if (el.getModelElement() instanceof IGatewayBean){
						
						//add into lane
						laneBean.addGateway((IGatewayBean) el.getModelElement());
							
						
						
					}else if (el.getModelElement() instanceof IIntermediateCatchEventBean){
						
						laneBean.addIntermediateCatchEvent((IIntermediateCatchEventBean) el.getModelElement());
							
						
						
					}else if (el.getModelElement() instanceof IIntermediateThrowEventBean){
						
						//add into lane
						laneBean.addIntermediateThrowEvent((IIntermediateThrowEventBean) el.getModelElement());
							
						
						
					}else if (el.getModelElement() instanceof IStartEventBean){
						
						//add into lane
						laneBean.addStartEvent((IStartEventBean) el.getModelElement());
							

					}else if (el.getModelElement() instanceof ITaskBean){
						
						//add into lane
						laneBean.addTask((ITaskBean) el.getModelElement());
							

					}else if (el.getModelElement() instanceof ILaneBean){
						
						//if actual child is a laneBean => check if actual lane has a childlaneset
						//if not create it
						if (laneBean.getChildLaneSet()==null){
							
							
							laneBean.setChildLaneSet(new LaneSetBean(IdGenerator.createUniqueId()));
							
							
						}
						
						//finally add lane into laneset if it does not already contain it 
						laneBean.getChildLaneSet().addLane((ILaneBean) el.getModelElement());
						
					}
		
				}
		
		
	}



}
