/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IHasDefaultChildren;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Rectangle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.IResizable;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.IResizableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.events.IResizeEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.events.IResizeHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.events.IResizeStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.events.IResizeStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.DefaultBoundsUpdateHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.events.PositionChangeEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.DroppableDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.resizable.ResizableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.resizable.events.ResizeEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.resizable.events.ResizeHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.resizable.events.ResizeStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.resizable.events.ResizeStopEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.swimlane.PoolEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNShape;
import com.google.gwt.core.client.GWT;

public class Pool extends Swimlane implements IResizable,ResizeHandler,IHasDefaultChildren{
	
	private Rectangle boundary;
	private Rectangle labelZone;
	private Rectangle dropZone;
	
	
	
	protected static final int LABEL_ZONE_WIDTH = 20; 
	protected static final int DEFAULT_WIDTH = 500;
	protected static final int DEFAULT_HEIGHT = 200;
	
	private DroppableDefaultHandlers droppableDefaultHandlers;
	
	private ResizableElementDefaultHandlers resizableDefaultHanders;
	
	private float widthOnStartResize;
	private float heightOnStartResize;
	

	
	public Pool(ProcessPanel definitionPanel,String id) {
		super(definitionPanel,id);
		
		BPMNShape shape = (BPMNShape) this.getDiagramElement();
		shape.setExpanded(true);
		
		this.resizableDefaultHanders = new ResizableElementDefaultHandlers(this);
		this.resizableDefaultHanders.attachDefaultHandlers();
		
		this.addResizeHandler(this);
		
		widthOnStartResize = DEFAULT_WIDTH;
		heightOnStartResize = DEFAULT_HEIGHT;
	
		DefaultBoundsUpdateHandlers dbuh = new DefaultBoundsUpdateHandlers(this);
		dbuh.attachDefaultHandlers();
	}
	
	public String getName() {
		return "Pool (Participant)";
	}
	
	
	@Override
	protected void onLoad() {
		super.onLoad();

	}
	
	@Override
	protected void init() {
		super.init();
		
		
		this.labelZone = this.getDefinitionPanel().getCanvas().createRectangle(0, 0, LABEL_ZONE_WIDTH, DEFAULT_HEIGHT);
		this.labelZone.setFillColour("white");

		this.dropZone = this.getDefinitionPanel().getCanvas().createRectangle(LABEL_ZONE_WIDTH, 0, (DEFAULT_WIDTH-LABEL_ZONE_WIDTH), DEFAULT_HEIGHT);
		this.dropZone.setFillColour("white");
		
		this.label	  = this.getDefinitionPanel().getCanvas().createText(10, (DEFAULT_HEIGHT/2), "");
		this.label.rotate(270, false);
		
		this.getGroup().appendChild(labelZone);
		this.getGroup().appendChild(dropZone);
		this.getGroup().appendChild(label);

	}
	
	public void addLane(Lane lane){
		this.addUIElement(lane);
		lane.setParentPool(this);
	}
	
	
	@Override
	public void setWidth(float width) {
		super.setWidth(width);
		dropZone.setWidth(width-LABEL_ZONE_WIDTH);
	}
	
	@Override
	public void setHeight(float height) {
		super.setHeight(height);
		labelZone.setHeight(height);
		label.setY(height/2);
		dropZone.setHeight(height);
	}
	
	public LinkedHashMap<String, IUIElement> getLanes() {
		return this.getChildrenUIElements();
	}
	
	
	@Override
	public SVGElement getMainShape() {
		
		if (boundary==null){
			
			boundary = this.getDefinitionPanel().getCanvas().createRectangle(0, 0, DEFAULT_WIDTH, DEFAULT_HEIGHT);
			boundary.setFillColour("white");
			boundary.setStokeColour("black");
		
		}
			
		return boundary;
	}


	public HashSet<Class<? extends IDraggableElement>> getAcceptedTypes() {
		
		HashSet<Class<? extends IDraggableElement>> result = new HashSet<Class<? extends IDraggableElement>>();
		
		result.add(Lane.class);

		
		return result;
	}


//	public IPoint getNorthWestPoint() {
//		Point p  = new Point(boundary.getAbsoluteLeft(), boundary.getAbsoluteTop());
//
//		return p;
//	}
//
//	public IPoint getSouthEastPoint() {
//		
//		Point p = new Point(boundary.getAbsoluteLeft()+boundary.getWidth(), dropZone.getAbsoluteTop()+boundary.getHeight());
//
//		return p;
//	}

	public void onDropAccepted(IDropAcceptedEvent event) {
		

		
	}

	
	@Override
	public void addUIElement(IUIElement uiElement) {
		super.addUIElement(uiElement);
		
		if (uiElement instanceof Lane){
			
			Lane lane = (Lane) uiElement;
			
			//if pool already contains a lane => same size should be applied
			if (this.getLanes().size()>0){
				
				Lane existingLane = (Lane) this.getLanes().values().iterator().next();
				
				lane.setWidth(existingLane.getWidth());
				lane.setHeight(existingLane.getHeight());
				
			}
			
			
		}
		
	}
	
	
	public void onDropRefused(IDropRefusedEvent event) {
		

		
	}

	public void onOut(IOutEvent event) {
		
		this.dropZone.setFillColour("white");

	}

	public void onOver(IOverEvent event) {
		

		this.getGroup().toBack();
		
		for(IUIElement l:getLanes().values()){
			
			Lane lane = (Lane) l;
			lane.getGroup().toFront();
			
		}
//		
//		if (event.getDraggableElement() instanceof Lane){
//			
//			this.dropZone.setFillColour("blue");
//			
//		}else if (event.getDraggableElement() instanceof DraggableProxy){
//			
//			DraggableProxy proxy 			= (DraggableProxy) event.getDraggableElement();
//			
//			IBPMNDragProxyData bpmndata 	= (IBPMNDragProxyData) proxy.getHasDraggableElementProxy();
//			
//			if (bpmndata.getBPMNElementType()==Lane.class){
//				this.dropZone.setFillColour("blue");
//			}else{
//				this.dropZone.setFillColour("red");
//			}
//			
//			
//		}else{
//			
//			this.dropZone.setFillColour("red");
//			
//		}


	}

	public IEditorModel getEditorModel() {
		
		if (editorModel==null){
			this.editorModel = GWT.create(PoolEditorModel.class);
		}
		
		return editorModel;
	}

//	public HashSet<IDiagramElementGraphicState> getStates() {
//		// TODO Auto-generated method stub
//		return null;
//	}



	/**
	 * Resize the pool and places all lanes
	 */
	public void refresh(){
		
		float x = LABEL_ZONE_WIDTH;
		float y = 0;
		float maxWidth = 0;
		for (Iterator<IUIElement> it = getLanes().values().iterator(); it.hasNext();) {
		      
			IUIElement el = it.next();
			
			if (el.getWidth()>maxWidth){
				maxWidth = el.getWidth();
			}
			
			float oldRelativeX = el.getRelativeX();
			float oldRelativeY = el.getRelativeY();
			
			el.setRelativeX(x);
			el.setRelativeY(y);
			
			el.fireEvent(new PositionChangeEvent(oldRelativeX, oldRelativeY, x, y));
			
			y = y + el.getHeight();			
	   }


		if (y==0) y=DEFAULT_HEIGHT;
		if (maxWidth==0) maxWidth=DEFAULT_WIDTH;
			
		this.setWidth(maxWidth+LABEL_ZONE_WIDTH);
		
		this.setHeight(y);

		this.resizableDefaultHanders.refreshUIHandlersPositions();
	}

	
	@Override
	public void onStart(IDragStartEvent event) {
		

		
	}
	
	
	@Override
	public void onMove(IDragMoveEvent event) {
	 
		
	
	}
	
	
	
	@Override
	public void onStop(IDragStopEvent event) {
		


		
	}

	public void addResizeHandler(IResizeHandler handler) {
		handlerManager.addHandler(ResizeStartEvent.TYPE,(ResizeHandler) handler);
		handlerManager.addHandler(ResizeStopEvent.TYPE,(ResizeHandler) handler);
		handlerManager.addHandler(ResizeEvent.TYPE,(ResizeHandler) handler);
	}

	public IPoint getNorthEastPoint() {

		return null;
	}

	public IResizableElementDefaultHandlers getResizableDefaultHandlers() {

		return resizableDefaultHanders;
	}

	public IPoint getSouthWestPoint() {

		return null;
	}

	public boolean isResizableOnNorthEast() {
		return false;
	}

	public boolean isResizableOnNorthWest() {
		return false;
	}

	public boolean isResizableOnSouthEast() {
		return true;
	}

	public boolean isResizableOnSouthWest() {
		return false;
	}




	public void onResize(IResizeEvent event) {

	}




	public void onStart(IResizeStartEvent event) {
		

		this.widthOnStartResize 	= this.getWidth();
		this.heightOnStartResize	= this.getHeight();
	}




	public void onStop(IResizeStopEvent event) {

		float widthGrowth = 1+((this.getWidth()-this.widthOnStartResize)/this.widthOnStartResize);
		float heightGrowth = 1+((this.getHeight()-this.heightOnStartResize)/this.heightOnStartResize);

		//resize all lanes if we are > than default values
		resizeLanes(widthGrowth, heightGrowth);

	
		this.refresh();
		
		
	}


	private void resizeLanes(float widthGrowth,float heightGrowth){
		
		for (Iterator<IUIElement> it = getLanes().values().iterator(); it.hasNext();) {
		      
			IUIElement el = it.next();
			
			if (el instanceof Lane){
				//TODO: consider lane content 
				float previewWidth = el.getWidth()*widthGrowth;
				float prevewHeight = el.getHeight()*heightGrowth;
				if (previewWidth>DEFAULT_WIDTH) el.setWidth((previewWidth));
				if (prevewHeight>DEFAULT_HEIGHT) el.setHeight((prevewHeight));

			}
			
	   }		
		
	}

	@Override
	public Set<IDiagramElement> getChildrenDIModels() {
		
		HashSet<IDiagramElement> result = new HashSet<IDiagramElement>();
		
		BPMNShape lane 		= GWT.create(BPMNShape.class);
		LaneBean laneBean 	= new LaneBean();
		laneBean.setName("Lane");
		lane.setModelElement(laneBean);
		result.add(lane);
		
		return result;
	}

	









	
	
}
