/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementViewInstantiationHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.choreography.Participant;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.CoreBPMNElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ChoreographyPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNShape;

public class PoolInstantiationHandler implements IDiagramElementViewInstantiationHandler<CoreBPMNElement>{
	
	private ParticipantType type;
	private IDiagramElement diagramElement;
	
	public PoolInstantiationHandler(ParticipantType type) {
		this.type = type;
	}
	
	@Override
	public CoreBPMNElement createElement(IModelElement syntaxModel,
			IDiagramView diagramView) {
		
		String id = IdGenerator.createUniqueId();
		
		if (syntaxModel!=null) id = syntaxModel.getId();
		
		CoreBPMNElement pool = null;
		
		
		//loading
		if (diagramElement!=null){
			
			IBPMNShape shape = (IBPMNShape) diagramElement;
			
			//NO PARTICIPANT BAND KIND
			if (shape.getParticipantBandKind()==null) {
			
				if (shape.isExpanded()==true){
					
					pool = new Pool((ProcessPanel) diagramView, id);
					
				}else if(shape.isExpanded()==false) {
					
					pool = new CollapsedPool((ProcessPanel) diagramView, id);
				
				}
			
			}else{
			//PARTICIPANTBANDKIND!=NULL => Choreography participant	
				
					pool = new Participant((ChoreographyPanel) diagramView, id);
				
			}
			
		//ui	
		}else{
			
			if (type==ParticipantType.Expanded){
				pool = new Pool((ProcessPanel) diagramView, id);
			}else if(type==ParticipantType.Collapsed){
				pool = new CollapsedPool((ProcessPanel) diagramView, id);
			}else if(type==ParticipantType.Choreography){
				pool = new Participant((ChoreographyPanel) diagramView, id);
			}
			
			
		}
		
		
		
		return pool;
	}

	@Override
	public CoreBPMNElement instantiate(IDiagramElement diagramElement,
			IDiagramView diagramView) {
		this.diagramElement = diagramElement;
		return createElement(diagramElement.getModelElement(), diagramView);
	}

	@Override
	public CoreBPMNElement instantiate(IHasDragProxy draggableProxyData,
			IDiagramView diagramView) {

		return createElement(null, diagramView);
	}

	public enum ParticipantType{
		Expanded,Collapsed,Choreography
	}
	
}
