/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common;

import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.events.IDragProxyContextualMenuHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyRefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.activities.TaskDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.Activity;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.artifacts.TextAnnotation;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.Association;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.DataAssociation;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.MessageFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.SequenceFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.Data;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.Message;

public class ContextualMenuHandler implements IDragProxyContextualMenuHandler{

	private IConnectableElement bpmnelement;
	private IUIPanel uipanel;
	
	public ContextualMenuHandler(IConnectableElement connectableElement) {
		this.bpmnelement = connectableElement;
		this.uipanel	 = bpmnelement.getUIPanel();
	}
	
	public IUIPanel getUIPanel() {
		return uipanel;
	}
	
	public void onProxyRefusedBeforeDrop(IProxyRefusedBeforeDropEvent event) {}
	
	public void onProxyRefusedAfterDrop(IProxyRefusedAfterDropEvent event) {}
	
	public void onProxyDragStop(IProxyDragStopEvent event) {}
	
	public void onProxyDragStart(IProxyDragStartEvent event) {}
	
	public void onProxyDragMove(IProxyDragMoveEvent event) {}
	
	public void onProxyAcceptedBeforeDrop(IProxyAcceptedBeforeDropEvent event) {}
	
	public void onProxyAcceptedAfterDrop(IProxyAcceptedAfterDropEvent event) {

		if ( event.getDragProxy().getHasDraggableElementProxy().getCreatedElement() instanceof SequenceFlow ==false &&
				event.getDragProxy().getHasDraggableElementProxy().getCreatedElement() instanceof MessageFlow ==false &&
				event.getDragProxy().getHasDraggableElementProxy().getCreatedElement() != null){
			
			if (event.getDragProxy().getHasDraggableElementProxy().getCreatedElement() instanceof Data && (event.getDragProxy().getHasDraggableElementProxy().getCreatedElement() instanceof Message ==false)|| 
				bpmnelement instanceof Data ){
				
				DataAssociation da = (DataAssociation) getUIPanel().getElementFactory().getElement(DataAssociation.class);
				getUIPanel().addUIElement(da);
				da.connect(bpmnelement, (IConnectableElement) event.getDragProxy().getHasDraggableElementProxy().getCreatedElement());
				
			}else if (event.getDragProxy().getHasDraggableElementProxy().getCreatedElement() instanceof Message || event.getDragProxy().getHasDraggableElementProxy().getCreatedElement() instanceof TextAnnotation){
					
				Association assoc = (Association) getUIPanel().getElementFactory().getElement(Association.class);
				getUIPanel().addUIElement(assoc);
				assoc.connect(bpmnelement, (IConnectableElement) event.getDragProxy().getHasDraggableElementProxy().getCreatedElement());
				
			}else{
				
				SequenceFlow sf = (SequenceFlow) getUIPanel().getElementFactory().getElement(SequenceFlow.class);
				getUIPanel().addUIElement(sf);
				sf.connect(bpmnelement, (IConnectableElement) event.getDragProxy().getHasDraggableElementProxy().getCreatedElement());
				
			}
			

			
		}
	
		
	}
	
}
