/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Circle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Marker;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Path;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.connector.MessageFlowEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;
import com.google.gwt.core.client.GWT;

public class MessageFlow extends ConnectorFlow{
	
	
	private MessageFlowEditorModel editorModel;
	

	
	public MessageFlow(IUIPanel uipanel, String id) {
		super(uipanel, id);
		

		
		Marker messageFlowEndMarker = ((ProcessPanel)uipanel).getCanvas().createMarker(IdGenerator.createUniqueId());
		Path sequenceFlowArrow = ((ProcessPanel)uipanel).getCanvas().createPath("M 0 1 L 15 6 L 0 11z", 0, 0);
		sequenceFlowArrow.setFillColour("white");
		sequenceFlowArrow.getElement().setAttribute("transform", "scale(0.5)");
		
		messageFlowEndMarker.setRefX(7);
		messageFlowEndMarker.setRefY(3);
		messageFlowEndMarker.appendChild(sequenceFlowArrow);

		messageFlowEndMarker.setHeight(10);
		messageFlowEndMarker.setWidth(10);
		messageFlowEndMarker.setOrient("auto");
		
		
		this.visibleLinearPath.setMarkerEnd(messageFlowEndMarker);
		this.visibleLinearPath.getElement().setAttribute("stroke-width", "2");
		
		visibleLinearPath.setStrokeDashArray("- ");

		
		Circle c = ((ProcessPanel) this.getUIPanel()).getCanvas().createCircle(4, 3, 2);
		c.setFillColour("white");
		
		Marker m = ((ProcessPanel) this.getUIPanel()).getCanvas().createMarker(
		"MessageFlowStart");
		m.setRefX(4);
		m.setRefY(3);
		m.appendChild(c);
//		m.appendChild(r);
		
		m.setHeight(200);
		m.setWidth(200);
		m.setOrient("auto");
		
		this.visibleLinearPath.setMarkerStart(m);
		
		
		
	}
	
	public String getName() {
		return "Message Flow";
	}
	
	public IEditorModel getEditorModel() {
		
		if (editorModel==null){
			this.editorModel = GWT.create(MessageFlowEditorModel.class);
		}
		
		return editorModel;
	}




}
