/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data;

import java.util.HashSet;
import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Path;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Rectangle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasMenuDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.BPMNElementsPath;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.data.DataOutputEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;
import com.google.gwt.core.client.GWT;

public class DataOutput extends Data {
	
	private Path mainPath;
	
	private Rectangle invisibleRectangle;
	
	private DataOutputEditorModel dataEditorModel;
	

	public DataOutput(ProcessPanel definitionPanel,
			String id) {
		super(definitionPanel, id);


	}
	
	
	@Override
	protected void init() {
		super.init();
		
		mainPath = this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.DATA_OUTPUT, 0, 0);
		mainPath.setFillColour("black");
		
		
		this.label  = this.getDefinitionPanel().getCanvas().createText(15, 50,"");
		this.getGroup().appendChild(label);
		
		getGroup().appendChild(mainPath);
	
	}
	
	
	@Override
	public SVGElement getMainShape() {
		
		if (invisibleRectangle==null){
			
			invisibleRectangle = this.getDefinitionPanel().getCanvas().createRectangle(0, 0, 30, 45);
			invisibleRectangle.setFillColour("white");
			invisibleRectangle.setStokeColour("white");

		}
		
		return invisibleRectangle;
	}



	@Override
	public LinkedHashSet<IHasMenuDragProxy> getDragProxies() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Direction getMenuDirection() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getName() {
		return "Data Output";
	}

	@Override
	public HashSet<Class<? extends IDraggableElement>> getAcceptedTypes() {
		
		HashSet<Class<? extends IDraggableElement>> types = new HashSet<Class<? extends IDraggableElement>>();
		
		return types;
	}




	@Override
	public HashSet<IDiagramElementViewConformityRule> getConformityRules() {
		if (getDefinitionPanel().isExecutableProcess()) {
			return new ExecutableProcessDataRules(this).getRules();
		}
		return null;
	}


	@Override
	public IEditorModel getEditorModel() {
		
		if (dataEditorModel==null){
			this.dataEditorModel  = GWT.create(DataOutputEditorModel.class);
		}
		
		return dataEditorModel;
	}



	@Override
	public void onDropAccepted(IDropAcceptedEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onDropRefused(IDropRefusedEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onOut(IOutEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onOver(IOverEvent event) {
		// TODO Auto-generated method stub
		
	}




}
